/*************************************************************************************************/
/*!
   	@file		ifileaccess.h
	@author 	Fanzo
 	@date 		2008/3/26
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFileStream.h"
#include	<string>

#pragma pack( push , 8 )		//set align

namespace icubic
{
using namespace std;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IFileReader" interface 
***************************************************************************************************/
cb_guid_define( IFileReader_IID , 0xCDAE4373 , 0x21E14aab , 0x9B042B09 , 0x7EB4D834 );
class IFileReader;
typedef icubic::iface_object< IFileReader , IFileReader_IID >	iFileReader;
typedef icubic::iface_reference< IFileReader , IFileReader_IID >	rFileReader;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IFileReader : public IFileStreamRead
{
public:
//=================================================================================================
//!	open
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call Open
		(
		const wchar_t*	path
		) = 0;
//=================================================================================================
//!	close
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Close() = 0;
};

/**************************************************************************************************
 "IFileWriter" interface 
***************************************************************************************************/
cb_guid_define( IFileWriter_IID , 0x737BF199 , 0xC3C44161 , 0xB1981C47 , 0x08EF0001 );
class IFileWriter;
typedef icubic::iface_object< IFileWriter , IFileWriter_IID >		iFileWriter;
typedef icubic::iface_reference< IFileWriter , IFileWriter_IID >	rFileWriter;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IFileWriter : public IFileStreamWrite
{
public:
//=================================================================================================
//!	open
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call Open
		(
		const wchar_t*	path
		) = 0;
//=================================================================================================
//!	close
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Close() = 0;
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
