/*************************************************************************************************/
/*!
   	@file		pp_sse_gradation_linear.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
//=================================================================================================
// const
//=================================================================================================
///////////////////////////////
// b


///////////////////////////////
// w













///////////////////////////////
// dw
























///////////////////////////////
// ps













//=================================================================================================
// convert
//=================================================================================================
///////////////////////////////////////////////////////////
// 

///////////////////////////////////////////////////////////
//dw 




///////////////////////////////////////////////////////////
//w






///////////////////////////////////////////////////////////
//b






//=================================================================================================
// cmpadd
//=================================================================================================









//=================================================================================================
// cmpsub
//=================================================================================================









//=================================================================================================
// cmpset
//=================================================================================================









//=================================================================================================
// not
//=================================================================================================

//=================================================================================================
// cmpadd , cmpsub
//=================================================================================================




//=================================================================================================
// set
//=================================================================================================









//=================================================================================================
// set
//=================================================================================================









//=================================================================================================
// rotate
//=================================================================================================
////////////////////////
//ps






////////////////////////
//dw






////////////////////////
//w








////////////////////////
//b
















//=================================================================================================
// fill
//=================================================================================================
////////////////////////
//ps




////////////////////////
//dw




////////////////////////
//w










////////////////////////
//b


















//=================================================================================================
// Load
//=================================================================================================




//=================================================================================================
// Load
//=================================================================================================
//=================================================================================================
// loop
//=================================================================================================
///////////////////////////////////////////////////////////////////////////////////////////////////
// Loop



///////////////////////////////////////////////////////////////////////////////////////////////////
// LoopCount

/*=================================================================================================
[ pixelformat ]
0 <= a <= 255   0 <= r <= 255   0 <= g <= 255   0 <= b <= 255  
0 <= aa <= 255   0 <= ar <= 255   0 <= ag <= 255   0 <= ab <= 255
rgb			byte	[-,r,g,b]
rgba		byte	[a,r,g,b]
a			byte	[a,-,-,-]
wrgb		word	[-,r,g,b]
wrgba		word	[a,r,g,b]
wa			word	[a,-,-,-]
drgb		dword	[-,r,g,b]
drgba		dword	[a,r,g,b]
da			dword	[a,-,-,-]
frgb		float	[-,r,g,b]
frgba		float	[a,r,g,b]
fa			float	[a,-,-,-]

rgb2		[ - , - , rgb,rgb]
rgb4		[rgb,rgb,rgb,rgb]
rgba2		[-,-,rgba,rgba]
rgba4		[rgba,rgba,rgba,rgba]
wrgb2		[wrgb,wrgb]
wrgba2		[wrgba,wrgba]
=================================================================================================*/

//=================================================================================================
// misc
//=================================================================================================
///////////////////////////////////////////////////////////////////////////////////////////////////
//sc_color




//=================================================================================================
// color to
//=================================================================================================
// wrgb

// wrgba

// wa

// frgb

// frgba

// fa

//=================================================================================================
// misc
//=================================================================================================
///////////////////////////////////////////////////////////////////////////////////////////////////
// a to aaaa

///////////////////////////////////////////////////////////////////////////////////////////////////
// a to aaaa


//=================================================================================================
// convert
//=================================================================================================
///////////////////////////////////////////////////////////////////////////////////////////////////
//rgb_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//rgba_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//wrgb_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//wrgba_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//drgb_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//drgba_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//frgb_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//frgba_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//a_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//fa_to

// a

// wa

// da

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//wa_to

// a

// wa

// da

// fa

//=================================================================================================
// mul alpha
//=================================================================================================
// wrgb

// wrgba

// wa

// frgb

// frgba

// fa

//=================================================================================================
// convert pack
//=================================================================================================
///////////////////////////////////////////////////////////////////////////////////////////////////
//

///////////////////////////////////////////////////////////////
// rgb

// rgb->rgb2

// rgb2->rgb

// rgb2->rgb4

// rgb4->rgb2

// rgb2->wrgb2

// wrgb2->rgb2

///////////////////////////////////////////////////////////////
// rgba

// rgba->rgba2

// rgba2->rgba

// rgba2->rgba4

// rgba4->rgba2

// rgba2->wrgba2

// wrgba2->rgba2

// wrgba->wrgba2

// wrgba2->wrgba

//=================================================================================================
// load var
//=================================================================================================

// rgb

// rgba

// frgb

// frgba

// wrgb

// wrgba

// drgb

// drgba

//=================================================================================================
// load addr
//=================================================================================================

// rgb

// rgba

// a

//=================================================================================================
// load addr index
//=================================================================================================

// rgb

// rgba

// a


//=================================================================================================
// load addr index
//=================================================================================================

// rgb

// rgba

//=================================================================================================
// load addr byteindex
//=================================================================================================

// rgb

// rgba

//=================================================================================================
// store var
//=================================================================================================

// rgb

// rgba

// frgb

// frgba

// wrgb

// wrgba

// drgb

// drgba

//=================================================================================================
// store addr
//=================================================================================================

// rgb

// rgba

// a

//=================================================================================================
// store addr index
//=================================================================================================

// rgb

// rgba

//=================================================================================================
// add pixel size
//=================================================================================================

// rgb

// rgba

// a

// rgb

// rgba

// rgba

//=================================================================================================
// sub pixel size
//=================================================================================================

// rgb

// rgba

// a

// rgb

// rgba

// rgba

//=================================================================================================
// pixoffset_to_byteoffset
//=================================================================================================


//=================================================================================================
// load addr color16
//=================================================================================================
/*
	destformat	= rgb , rgba , rgbaaa , wrgb , wrgba , wrgbaaa , drgb , drgba , drgbaaa
	srcformat	= rgb , rgba , rgbaaa
	src_pitchbyte_dw4_var	= pitch , pitch , pitch , pitch
	color_var	= color_var_00 , color_var_10 , color_var_20 , color_var_30 , ... , color_var_33
	alpha_var	= alpha_var_00 , alpha_var_10 , alpha_var_20 , alpha_var_30 , ... , alpha_var_33
	x_dw4_xmm	= x3 : x2 : x1 : x0
	y_dw4_xmm	= y3 : y2 : y1 : y0
	w_dw4_xmm	= w : w : w : w
*/

//=================================================================================================
// add pixel
//=================================================================================================
// wrgb

// wrgba

// wa

//=================================================================================================
// shift pixel
//=================================================================================================
// wrgb

// wrgba

// wa

//=================================================================================================
// gradation linear w
//=================================================================================================
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------

//=================================================================================================
// gradation linear f
//=================================================================================================
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------

#pragma pack( push , 8 )		//set align

namespace icubic
{
//=================================================================================================
// gradation linear
//=================================================================================================

//=================================================================================================
cb_inline
void pp_sse_gradation_linear_i16_rgb
		(
		void*			dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const int16*	blendtbl
		)
{
	static const __m128	const_dw_0 = sse_set_dw( 0 , 0 , 0 , 0 );
	static const __m128	const_b_0 = sse_set_ub( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_w_256 = sse_set_w( 256 , 256 , 256 , 256 , 256 , 256 , 256 , 256 );
	__m128	sc = sse_set_uw( 0 , 0 , 0 , 0 , ( uint8 )( ( 255 * (uint32)ss_color.b * (uint32)ss_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)ss_color.g * (uint32)ss_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)ss_color.r * (uint32)ss_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)ss_color.a ) >> 8 ) );
	__m128	tc = sse_set_uw( 0 , 0 , 0 , 0 , ( uint8 )( ( 255 * (uint32)st_color.b * (uint32)st_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)st_color.g * (uint32)st_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)st_color.r * (uint32)st_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)st_color.a ) >> 8 ) );
	
	// def tbloff
	int32	ist	= ( int32 )( st * ( 256 << 16 ) );
	int32	itt	= ( int32 )( tt * ( 256 << 16 ) );
	ist	= ist < 0 ? 0 : ( ist >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : ist );
	itt	= itt < 0 ? 0 : ( itt >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : itt );
		
	int32	tbl_def	= ( itt - ist ) / ( len == 1 ? 1 : (len-1) );
	int32	tbl_off	= ist;

	_asm
	{
		movaps	xmm3 , sc
		movaps	xmm4 , tc
		mov		eax , dest
		mov		ecx , tbl_off
		mov		edx , blendtbl
	len_loop_start:
		dec		len
		jl		len_loop_end
			sar		ecx , 16
			mov		cx , [ edx + ecx * 2 ]

		// c' = ( sc * d + tc * ( 256-d ) ) / 256
		movd		xmm1 , ecx
		punpcklwd	xmm1 , xmm1
		punpcklwd	xmm1 , xmm1
		movaps		xmm0 , const_w_256
		psubw		xmm0 , xmm1
		pmullw		xmm0 , xmm4
		pmullw		xmm1 , xmm3
		paddusw		xmm0 , xmm1
		psrlw		xmm0 , 8

		packuswb	xmm0 , const_dw_0
		movd	[ eax ] , xmm0
		add		eax , 4
			mov		ecx , tbl_off
			add		ecx , tbl_def
			mov		tbl_off , ecx
		jmp		len_loop_start
	len_loop_end:
	}
}
//=================================================================================================
cb_inline
void pp_sse_gradation_linear_i16_rgba
		(
		void*			dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const int16*	blendtbl
		)
{
	static const __m128	const_dw_0 = sse_set_dw( 0 , 0 , 0 , 0 );
	static const __m128	const_b_0 = sse_set_ub( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_w_256 = sse_set_w( 256 , 256 , 256 , 256 , 256 , 256 , 256 , 256 );
	__m128	sc = sse_set_uw( 0 , 0 , 0 , 0 , ( uint8 )( ( 255 * (uint32)ss_color.b * (uint32)ss_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)ss_color.g * (uint32)ss_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)ss_color.r * (uint32)ss_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)ss_color.a ) >> 8 ) );
	__m128	tc = sse_set_uw( 0 , 0 , 0 , 0 , ( uint8 )( ( 255 * (uint32)st_color.b * (uint32)st_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)st_color.g * (uint32)st_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)st_color.r * (uint32)st_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)st_color.a ) >> 8 ) );
	
	// def tbloff
	int32	ist	= ( int32 )( st * ( 256 << 16 ) );
	int32	itt	= ( int32 )( tt * ( 256 << 16 ) );
	ist	= ist < 0 ? 0 : ( ist >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : ist );
	itt	= itt < 0 ? 0 : ( itt >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : itt );
		
	int32	tbl_def	= ( itt - ist ) / ( len == 1 ? 1 : (len-1) );
	int32	tbl_off	= ist;

	_asm
	{
		movaps	xmm3 , sc
		movaps	xmm4 , tc
		mov		eax , dest
		mov		ecx , tbl_off
		mov		edx , blendtbl
	len_loop_start:
		dec		len
		jl		len_loop_end
			sar		ecx , 16
			mov		cx , [ edx + ecx * 2 ]

		// c' = ( sc * d + tc * ( 256-d ) ) / 256
		movd		xmm1 , ecx
		punpcklwd	xmm1 , xmm1
		punpcklwd	xmm1 , xmm1
		movaps		xmm0 , const_w_256
		psubw		xmm0 , xmm1
		pmullw		xmm0 , xmm4
		pmullw		xmm1 , xmm3
		paddusw		xmm0 , xmm1
		psrlw		xmm0 , 8

		packuswb	xmm0 , const_dw_0
		movd	[ eax ] , xmm0
		add		eax , 4
			mov		ecx , tbl_off
			add		ecx , tbl_def
			mov		tbl_off , ecx
		jmp		len_loop_start
	len_loop_end:
	}
}
//=================================================================================================
cb_inline
void pp_sse_gradation_linear_i16_a
		(
		void*			dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const int16*	blendtbl
		)
{
	static const __m128	const_dw_0 = sse_set_dw( 0 , 0 , 0 , 0 );
	static const __m128	const_b_0 = sse_set_ub( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_w_256 = sse_set_w( 256 , 256 , 256 , 256 , 256 , 256 , 256 , 256 );
	__m128	sc = sse_set_uw( 0 , 0 , 0 , 0 , 0 , 0 , 0 , ( uint8 )( ( 255 * (uint32)ss_color.a ) >> 8 ) );
	__m128	tc = sse_set_uw( 0 , 0 , 0 , 0 , 0 , 0 , 0 , ( uint8 )( ( 255 * (uint32)st_color.a ) >> 8 ) );
	
	// def tbloff
	int32	ist	= ( int32 )( st * ( 256 << 16 ) );
	int32	itt	= ( int32 )( tt * ( 256 << 16 ) );
	ist	= ist < 0 ? 0 : ( ist >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : ist );
	itt	= itt < 0 ? 0 : ( itt >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : itt );
		
	int32	tbl_def	= ( itt - ist ) / ( len == 1 ? 1 : (len-1) );
	int32	tbl_off	= ist;

	_asm
	{
		movaps	xmm3 , sc
		movaps	xmm4 , tc
		mov		eax , dest
		mov		ecx , tbl_off
		mov		edx , blendtbl
	len_loop_start:
		dec		len
		jl		len_loop_end
			sar		ecx , 16
			mov		cx , [ edx + ecx * 2 ]

		// c' = ( sc * d + tc * ( 256-d ) ) / 256
		movd		xmm1 , ecx
		movaps		xmm0 , const_w_256
		psubw		xmm0 , xmm1
		pmullw		xmm0 , xmm4
		pmullw		xmm1 , xmm3
		paddusw		xmm0 , xmm1
		psrlw		xmm0 , 8

		movd	ecx , xmm0
		mov		[ eax ] , cl
		add		eax , 1
			mov		ecx , tbl_off
			add		ecx , tbl_def
			mov		tbl_off , ecx
		jmp		len_loop_start
	len_loop_end:
	}
}


//=================================================================================================
cb_inline
void pp_sse_gradation_linear_f_rgb
		(
		void*			dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const float*	blendtbl
		)
{
	static const __m128	const_dw_0 = sse_set_dw( 0 , 0 , 0 , 0 );
	static const __m128	const_b_0 = sse_set_ub( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_w_256 = sse_set_w( 256 , 256 , 256 , 256 , 256 , 256 , 256 , 256 );
	static const __m128	const_w_0 = sse_set_w( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_f_255 = sse_set_ps( 255.0f , 255.0f , 255.0f , 255.0f );
	static const __m128	const_f_1 = sse_set_ps( 1.0f , 1.0f , 1.0f , 1.0f );
	__m128	sc = sse_set_ps( (float)ss_color.b * (float)ss_color.a * ( 1.0f / 65536.0f ) , (float)ss_color.g * (float)ss_color.a * ( 1.0f / 65536.0f ) , (float)ss_color.r * (float)ss_color.a * ( 1.0f / 65536.0f ) , (float)ss_color.a * ( 1.0f / 256.0f ) );
	__m128	tc = sse_set_ps( (float)st_color.b * (float)st_color.a * ( 1.0f / 65536.0f ) , (float)st_color.g * (float)st_color.a * ( 1.0f / 65536.0f ) , (float)st_color.r * (float)st_color.a * ( 1.0f / 65536.0f ) , (float)st_color.a * ( 1.0f / 256.0f ) );
	
	// def tbloff
	int32	ist	= ( int32 )( st * ( 256 << 16 ) );
	int32	itt	= ( int32 )( tt * ( 256 << 16 ) );
	ist	= ist < 0 ? 0 : ( ist >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : ist );
	itt	= itt < 0 ? 0 : ( itt >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : itt );
		
	int32	tbl_def	= ( itt - ist ) / ( len == 1 ? 1 : (len-1) );
	int32	tbl_off	= ist;

	_asm
	{
		movaps	xmm3 , sc
		movaps	xmm4 , tc
		mov		eax , dest
		mov		ecx , tbl_off
		mov		edx , blendtbl
	len_loop_start:
		dec		len
		jl		len_loop_end
			sar		ecx , 16
			mov		ecx , [ edx + ecx * 4 ]

		// c' = ( sc * d + tc * ( 1.0f-d ) )
		movd		xmm1 , ecx
		shufps	xmm1 , xmm1 , 0
		movaps		xmm0 , const_f_1
		subps		xmm0 , xmm1
		mulps		xmm0 , xmm4
		mulps		xmm1 , xmm3
		addps		xmm0 , xmm1

		mulps		xmm0 , const_f_255
		cvtps2dq	xmm0 , xmm0
		packssdw	xmm0 , const_dw_0
		packuswb	xmm0 , const_w_0
		movd	[ eax ] , xmm0
		add		eax , 4
			mov		ecx , tbl_off
			add		ecx , tbl_def
			mov		tbl_off , ecx
		jmp		len_loop_start
	len_loop_end:
	}
}
//=================================================================================================
cb_inline
void pp_sse_gradation_linear_f_rgba
		(
		void*			dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const float*	blendtbl
		)
{
	static const __m128	const_dw_0 = sse_set_dw( 0 , 0 , 0 , 0 );
	static const __m128	const_b_0 = sse_set_ub( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_w_256 = sse_set_w( 256 , 256 , 256 , 256 , 256 , 256 , 256 , 256 );
	static const __m128	const_w_0 = sse_set_w( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_f_255 = sse_set_ps( 255.0f , 255.0f , 255.0f , 255.0f );
	static const __m128	const_f_1 = sse_set_ps( 1.0f , 1.0f , 1.0f , 1.0f );
	__m128	sc = sse_set_ps( (float)ss_color.b * (float)ss_color.a * ( 1.0f / 65536.0f ) , (float)ss_color.g * (float)ss_color.a * ( 1.0f / 65536.0f ) , (float)ss_color.r * (float)ss_color.a * ( 1.0f / 65536.0f ) , (float)ss_color.a * ( 1.0f / 256.0f ) );
	__m128	tc = sse_set_ps( (float)st_color.b * (float)st_color.a * ( 1.0f / 65536.0f ) , (float)st_color.g * (float)st_color.a * ( 1.0f / 65536.0f ) , (float)st_color.r * (float)st_color.a * ( 1.0f / 65536.0f ) , (float)st_color.a * ( 1.0f / 256.0f ) );
	
	// def tbloff
	int32	ist	= ( int32 )( st * ( 256 << 16 ) );
	int32	itt	= ( int32 )( tt * ( 256 << 16 ) );
	ist	= ist < 0 ? 0 : ( ist >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : ist );
	itt	= itt < 0 ? 0 : ( itt >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : itt );
		
	int32	tbl_def	= ( itt - ist ) / ( len == 1 ? 1 : (len-1) );
	int32	tbl_off	= ist;

	_asm
	{
		movaps	xmm3 , sc
		movaps	xmm4 , tc
		mov		eax , dest
		mov		ecx , tbl_off
		mov		edx , blendtbl
	len_loop_start:
		dec		len
		jl		len_loop_end
			sar		ecx , 16
			mov		ecx , [ edx + ecx * 4 ]

		// c' = ( sc * d + tc * ( 1.0f-d ) )
		movd		xmm1 , ecx
		shufps	xmm1 , xmm1 , 0
		movaps		xmm0 , const_f_1
		subps		xmm0 , xmm1
		mulps		xmm0 , xmm4
		mulps		xmm1 , xmm3
		addps		xmm0 , xmm1

		mulps		xmm0 , const_f_255
		cvtps2dq	xmm0 , xmm0
		packssdw	xmm0 , const_dw_0
		packuswb	xmm0 , const_w_0
		movd	[ eax ] , xmm0
		add		eax , 4
			mov		ecx , tbl_off
			add		ecx , tbl_def
			mov		tbl_off , ecx
		jmp		len_loop_start
	len_loop_end:
	}
}
//=================================================================================================
cb_inline
void pp_sse_gradation_linear_f_a
		(
		void*			dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const float*	blendtbl
		)
{
	static const __m128	const_dw_0 = sse_set_dw( 0 , 0 , 0 , 0 );
	static const __m128	const_b_0 = sse_set_ub( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_w_256 = sse_set_w( 256 , 256 , 256 , 256 , 256 , 256 , 256 , 256 );
	static const __m128	const_w_0 = sse_set_w( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_f_255 = sse_set_ps( 255.0f , 255.0f , 255.0f , 255.0f );
	static const __m128	const_f_1 = sse_set_ps( 1.0f , 1.0f , 1.0f , 1.0f );
	__m128	sc = sse_set_ps( 0.0f , 0.0f , 0.0f , (float)ss_color.a * ( 1.0f / 256.0f ) );
	__m128	tc = sse_set_ps( 0.0f , 0.0f , 0.0f , (float)st_color.a * ( 1.0f / 256.0f ) );
	
	// def tbloff
	int32	ist	= ( int32 )( st * ( 256 << 16 ) );
	int32	itt	= ( int32 )( tt * ( 256 << 16 ) );
	ist	= ist < 0 ? 0 : ( ist >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : ist );
	itt	= itt < 0 ? 0 : ( itt >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : itt );
		
	int32	tbl_def	= ( itt - ist ) / ( len == 1 ? 1 : (len-1) );
	int32	tbl_off	= ist;

	_asm
	{
		movaps	xmm3 , sc
		movaps	xmm4 , tc
		mov		eax , dest
		mov		ecx , tbl_off
		mov		edx , blendtbl
	len_loop_start:
		dec		len
		jl		len_loop_end
			sar		ecx , 16
			mov		ecx , [ edx + ecx * 4 ]

		// c' = ( sc * d + tc * ( 1.0f-d ) )
		movd		xmm1 , ecx
		shufps	xmm1 , xmm1 , 0
		movaps		xmm0 , const_f_1
		subps		xmm0 , xmm1
		mulps		xmm0 , xmm4
		mulps		xmm1 , xmm3
		addps		xmm0 , xmm1

		mulps		xmm0 , const_f_255
		cvtps2dq	xmm0 , xmm0
		packssdw	xmm0 , const_dw_0
		packuswb	xmm0 , const_w_0
		movd	ecx , xmm0
		mov		[ eax ] , cl
		add		eax , 1
			mov		ecx , tbl_off
			add		ecx , tbl_def
			mov		tbl_off , ecx
		jmp		len_loop_start
	len_loop_end:
	}
}

//=================================================================================================
//!	gradation linear
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_sse_gradation_linear_i16
		(
		pp_format		destformat , 
		void*			dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const int16*	blendtbl
		)
{
	typedef void (*func)( void* , int32 , const pp_color& , const pp_color& , float , float , const int16* );

	static
	func	funclist[4] = 
	{	
	pp_sse_gradation_linear_i16_rgb , 
	pp_sse_gradation_linear_i16_rgba , 
	pp_sse_gradation_linear_i16_a , 
	};
	( funclist[ destformat ] )( dest , len , ss_color , st_color , st , tt , blendtbl );
}

//=================================================================================================
//!	gradation linear
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_sse_gradation_linear_f
		(
		pp_format		destformat , 
		void*			dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const float*	blendtbl
		)
{
	typedef void (*func)( void* , int32 , const pp_color& , const pp_color& , float , float , const float* );

	static
	func	funclist[4] = 
	{	
	pp_sse_gradation_linear_f_rgb , 
	pp_sse_gradation_linear_f_rgba , 
	pp_sse_gradation_linear_f_a , 
	};
	( funclist[ destformat ] )( dest , len , ss_color , st_color , st , tt , blendtbl );
}

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
