/*************************************************************************************************/
/*!
   	@file		pp_cpp_uv.h
	@author 	Fanzo
 	@date 		2008/4/21
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
//!	wrap repeat
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void WrapNear2_repeat
		(
		int32	x[2] , 
		int32	y[2] , 
		uint8	*dx , 
		uint8	*dy , 
		int32	u , 
		int32	v , 
		int32	w , 
		int32	h
		)
{
	u	= u & 0xFFFF;
	v	= v & 0xFFFF;
	int32	xx	= ( u * w ) >> 8;
	int32	yy	= ( v * h ) >> 8;
	xx -= 128;
	yy -= 128;
	*dx		= xx & 0xFF;
	*dy		= yy & 0xFF;
	xx >>= 8;
	yy >>= 8;
	x[0]	= xx;
	x[1]	= xx+1;
	y[0]	= yy;
	y[1]	= yy+1;
	x[0]	= x[0] < 0 ? w-1 : x[0];
	x[1]	= x[1] >= w ? 0 : x[1];
	y[0]	= y[0] < 0 ? h-1 : y[0];
	y[1]	= y[1] >= h ? 0 : y[1];
}
//=================================================================================================
//!	wrap repeat
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void WrapNear2_clamp
		(
		int32	x[2] , 
		int32	y[2] , 
		uint8*	dx , 
		uint8*	dy , 
		int32	u , 
		int32	v , 
		int32	w , 
		int32	h
		)
{
	u	= u < 0 ? 0 : ( ( u > 0xFFFF ) ? 0xFFFF : u );
	v	= v < 0 ? 0 : ( ( v > 0xFFFF ) ? 0xFFFF : v );
	int32	xx	= ( u * ( w - 1 ) ) >> 8;
	int32	yy	= ( v * ( h - 1 ) ) >> 8;
	*dx		= xx & 0xFF;
	*dy		= yy & 0xFF;
	xx >>= 8;
	yy >>= 8;
	x[0]	= xx;
	x[1]	= xx + 1;
	y[0]	= yy;
	y[1]	= yy + 1;
}
//=================================================================================================
//!	wrap repeat
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void WrapNear4_repeat
		(
		int32	x[4] , 
		int32	y[4] , 
		uint8*	dx , 
		uint8*	dy , 
		int32	u , 
		int32	v , 
		int32	w , 
		int32	h
		)
{
	u	= u & 0xFFFF;
	v	= v & 0xFFFF;
	int32	xx		= ( u * w ) >> 8;
	int32	yy		= ( v * h ) >> 8;
	xx -= 128;
	yy -= 128;
	*dx		= xx & 0xFF;
	*dy		= yy & 0xFF;
	xx >>= 8;
	yy >>= 8;
	x[0]	= xx-1;
	x[1]	= xx;
	x[2]	= xx+1;
	x[3]	= xx+2;
	y[0]	= yy-1;
	y[1]	= yy;
	y[2]	= yy+1;
	y[3]	= yy+2;

	x[0]	= x[0] == -2 ? w-2 : x[0];
	x[0]	= x[0] == -1 ? w-1 : x[0];
	x[1]	= x[1] == -1 ? w-1 : x[1];
	x[2]	= x[2] == w ? 0 : x[2];
	x[3]	= x[3] == w+1 ? 1 : x[3];
	x[3]	= x[3] == w ? 0 : x[3];
	
	y[0]	= y[0] == -2 ? h-2 : y[0];
	y[0]	= y[0] == -1 ? h-1 : y[0];
	y[1]	= y[1] == -1 ? h-1 : y[1];
	y[2]	= y[2] == h ? 0 : y[2];
	y[3]	= y[3] == h+1 ? 1 : y[3];
	y[3]	= y[3] == h ? 0 : y[3];
}
//=================================================================================================
//!	wrap repeat
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void WrapNear4_clamp
		(
		int32	x[4] , 
		int32	y[4] , 
		uint8*	dx , 
		uint8*	dy , 
		int32	u , 
		int32	v , 
		int32	w , 
		int32	h
		)
{
	u	= u < 0 ? 0 : ( ( u > 0xFFFF ) ? 0xFFFF : u );
	v	= v < 0 ? 0 : ( ( v > 0xFFFF ) ? 0xFFFF : v );
	int32	xx		= ( u * ( w - 1 ) ) >> 8;
	int32	yy		= ( v * ( h - 1 ) ) >> 8;
	*dx		= xx & 0xFF;
	*dy		= yy & 0xFF;
	xx >>= 8;
	yy >>= 8;
	x[0]	= xx-1;
	x[1]	= xx;
	x[2]	= xx+1;
	x[3]	= xx+2;
	y[0]	= yy-1;
	y[1]	= yy;
	y[2]	= yy+1;
	y[3]	= yy+2;
	x[0]	= x[0] < 0 ? 0 : x[0];
	x[1];
	x[2]	= x[2] >= w ? w-1 : x[2];
	x[3]	= x[3] >= w ? w-1 : x[3];
	y[0]	= y[0] < 0 ? 0 : y[0];
	y[1];
	y[2]	= y[2] >= h ? h-1 : y[2];
	y[3]	= y[3] >= h ? h-1 : y[3];
}
//=================================================================================================
//!	wrap repeat
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void Wrap_repeat
		(
		int32	*u , 
		int32	*v
		)
{
	*u	= *u & 0xFFFF;
	*v	= *v & 0xFFFF;
}
//=================================================================================================
//!	wrap repeat
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void Wrap_clamp
		(
		int32	*u , 
		int32	*v
		)
{
	*u	= *u < 0 ? 0 : ( ( *u > 0xFFFF ) ? 0xFFFF : *u );
	*v	= *v < 0 ? 0 : ( ( *v > 0xFFFF ) ? 0xFFFF : *v );
}

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
