/*************************************************************************************************/
/*!
   	@file		iTexture.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iPaint.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define
enum Wraptype
{
	Repeat_Wraptype = 0 , 
	Clamp_Wraptype = 1 , 
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "ITexture" interface 
***************************************************************************************************/
cb_guid_define( ITexture_IID , 0x137C6C42 , 0xA26842eb , 0x9FF52E0F , 0xD36563B6 );
class ITexture;
typedef icubic::iface_object< ITexture , ITexture_IID >		iTexture;
typedef icubic::iface_reference< ITexture , ITexture_IID >	rTexture;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ITexture
{
public:
	enum Type
	{
		Color , 
		Image , 
	};
public:
//=================================================================================================
//!	get size
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
isize cb_call TextureSize() = 0;
//=================================================================================================
//!	Get dpi
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
DPI cb_call TextureDPI() = 0;
//=================================================================================================
//!	get generate format
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
Type cb_call TextureType() = 0;
//=================================================================================================
//!	gen source
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
rgba cb_call TextureColor() = 0;
//=================================================================================================
//!	get default pixel format
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
pixelformat	cb_call TextureImageFormat() = 0;
//=================================================================================================
//!	begin source
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call BeginTextureImage() = 0;
//=================================================================================================
//!	gen source
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call TextureImage
		(
		void				*image , 
		int					pixlen , 
		const fvector2&		suv ,			//!< [in] uv map
		const fvector2&		tuv				//!< [in] uv map
		) = 0;
//=================================================================================================
//!	end source
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call EndTextureImage() = 0;
};

/**************************************************************************************************
 "ITextureSolidColor" interface 
***************************************************************************************************/
cb_guid_define( ITextureSolidColor_IID , 0x58180246 , 0xCE594ec5 , 0x970F6603 , 0xE42719C8 );
class ITextureSolidColor;
typedef icubic::iface_object< ITextureSolidColor , ITextureSolidColor_IID >		iTextureSolidColor;
typedef icubic::iface_reference< ITextureSolidColor , ITextureSolidColor_IID >	rTextureSolidColor;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ITextureSolidColor : public ITexture
{
public:
//=================================================================================================
//!	set color
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetColor
		(
		const rgba&	color
		) = 0;
//=================================================================================================
//!	get color
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
rgba cb_call GetColor() = 0;
};
/**************************************************************************************************
 "ITextureImage" interface 
***************************************************************************************************/
cb_guid_define( ITextureImage_IID , 0xA2CAAF3D , 0xF744473e , 0xB70646AA , 0xA6B84127 );
class ITextureImage;
typedef icubic::iface_object< ITextureImage , ITextureImage_IID >		iTextureImage;
typedef icubic::iface_reference< ITextureImage , ITextureImage_IID >	rTextureImage;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ITextureImage : public ITexture
{
public:
//=================================================================================================
//!	set transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetTransform
		(
		const faffine&	trans
		) = 0;
//=================================================================================================
//!	get transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
faffine cb_call GetTransform() = 0;
//=================================================================================================
//!	set wraptype
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetWraptype
		(
		Wraptype	wrap
		) = 0;
//=================================================================================================
//!	get wraptype
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
Wraptype cb_call GetWraptype() = 0;
//=================================================================================================
//!	set texture
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetTexture
		(
		iSurfaceSource&	texture
		) = 0;
//=================================================================================================
//!	release texture
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ReleaseTexture() = 0;
//=================================================================================================
//!	get texture
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iSurfaceSource cb_call GetTexture() = 0;
};
/**************************************************************************************************
 "ITexturePaint" interface 
***************************************************************************************************/
cb_guid_define( ITexturePaint_IID , 0x9F674864 , 0xB4004939 , 0xB2D9EA74 , 0x6FC0383A );
class ITexturePaint;
typedef icubic::iface_object< ITexturePaint , ITexturePaint_IID >		iTexturePaint;
typedef icubic::iface_reference< ITexturePaint , ITexturePaint_IID >	rTexturePaint;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ITexturePaint : public ITexture
{
public:
//=================================================================================================
//!	set texture info
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetTextureInfo
		(
		const DPI&			dpi , 
		const isize&		size
		) = 0;
//=================================================================================================
//!	set paint
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetPaint
		(
		iPaint	&gen
		) = 0;
//=================================================================================================
//!	release paint
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ReleasePaint() = 0;
//=================================================================================================
//!	set transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetTransform
		(
		const faffine&		trans
		) = 0;
//=================================================================================================
//!	get transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
faffine GetTransform()const = 0;
};


///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
