/*************************************************************************************************/
/*!
   	@file		TextureImageWeight16.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iTexture.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"TextureImageWeight16" class 
**************************************************************************************************/
class TextureImageWeight16 : 
	public ITextureImage , 
	virtual public object_base
{
// query
	query_begin()
	iface_hook( ITexture , ITexture_IID )
	iface_hook( ITextureImage , ITextureImage_IID )
	query_end( object_base )
	
// variable member
private:
	faffine				m_transform;
	iSurfaceSource		m_texture;
	Wraptype			m_wraptype;

	iNormTable_f		m_table1;
	iNormTable_f		m_table2;
			
// private functions
private:
//=================================================================================================
//!	get interpolate table
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void GetInterpolateTbl
		(
		const float**	p1 , 
		const float**	p2
		)
{
	if( m_table1 == false || m_table2 == false )
	{
		*p1	= TableBicubic1_f();
		*p2	= TableBicubic2_f();
	}
	else
	{
		*p1	= m_table1->GetNormTable();
		*p2	= m_table2->GetNormTable();
	}
}
// "ITexture" interface functions
public:
//=================================================================================================
isize cb_call TextureSize()
{
	return m_texture->GetSourceSize();
}
//=================================================================================================
DPI cb_call TextureDPI()
{
	return m_texture->GetSourceDPI();
}
//=================================================================================================
ITexture::Type cb_call TextureType()
{
	return ITexture::Image;
}
//=================================================================================================
rgba cb_call TextureColor()
{
	return rgba();
}
//=================================================================================================
pixelformat	cb_call TextureImageFormat()
{
	return m_texture->GetSourceFormat();
}
//=================================================================================================
bool cb_call BeginTextureImage()
{
	isize	size	= m_texture->GetSourceSize();
	if( size.width == 0 || size.height == 0 )
		return false;
	return true;
}
//=================================================================================================
void cb_call TextureImage
		(
		void				*image , 
		int					len , 
		const fvector2&		suv , 
		const fvector2&		tuv
		)
{
	fvector2	tsuv	= m_transform.Transform( suv );
	fvector2	ttuv	= m_transform.Transform( tuv );
	int			pitchbyte;
	const void*	p = m_texture->GetSourcePixelPtr( &pitchbyte );
	const float*	t1;
	const float*	t2;
	GetInterpolateTbl( &t1 , &t2 );
	pp_texture_weight16f_m
			(
			to_pp_format( m_texture->GetSourceFormat() ) , 
			image , 
			len , 
			tsuv.x , 
			tsuv.y , 
			ttuv.x , 
			ttuv.y , 
			to_pp_format( m_texture->GetSourceFormat() ) , 
			p , 
			pitchbyte , 
			m_texture->GetSourceSize().width , 
			m_texture->GetSourceSize().height , 
			to_pp_color( rgba() ) , 
			to_pp_alpha( 255 ) ,  
			to_pp_wraptype( m_wraptype ) , 
			t1 , 
			t2
			);
}
//=================================================================================================
void cb_call EndTextureImage()
{
}
// "ITextureImage" interface functions
public:
//=================================================================================================
void cb_call SetTransform
		(
		const faffine&	trans
		)
{
	m_transform	= trans;
}
//=================================================================================================
faffine cb_call GetTransform()
{
	return m_transform;
}
//=================================================================================================
void cb_call SetWraptype
		(
		Wraptype	wrap
		)
{
	m_wraptype	= wrap;
}
//=================================================================================================
Wraptype cb_call GetWraptype()
{
	return m_wraptype;
}
//=================================================================================================
void cb_call SetTexture
		(
		iSurfaceSource&	texture
		)
{
	m_texture	= texture;
}
//=================================================================================================
void cb_call ReleaseTexture()
{
	m_texture.release();
}
//=================================================================================================
iSurfaceSource cb_call GetTexture()
{
	return m_texture;
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
TextureImageWeight16() : m_wraptype( Repeat_Wraptype )
{
}
//=================================================================================================
//!	set iInterpolateTable
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetInterpolateTable
		(
		iNormTable_f&	table1 , 
		iNormTable_f&	table2
		)
{
	m_table1	= table1;
	m_table2	= table2;
}
//=================================================================================================
//!	get iInterpolateTable
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call ReleaseInterpolateTable()
{
	m_table1.release();
	m_table2.release();
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
