/*************************************************************************************************/
/*!
   	@file		Stackdata.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"DefaultStackInspector" class 
**************************************************************************************************/
template<class t_class>
class DefaultStackInspector
{
public:
//=================================================================================================
//!	poped
//!	@retval			if true , call destruct
//-------------------------------------------------------------------------------------------------
cb_inline
bool InspectorPop
		(
		t_class*	p
		)
{
	return true;
}
};

/**************************************************************************************************
"Stackdata" class 
**************************************************************************************************/
template<class t_class , class t_popinspector = DefaultStackInspector<t_class> >
class Stackdata
{
	cb_copy_impossible( Stackdata );
	
// member class
private:
	struct Header;
	typedef Header*		HeaderPtr;
	struct Header
	{
		bool		m_constructed;
		HeaderPtr	m_prev;
		HeaderPtr	m_next;
	};
// variable member
private:
	MemAllocator_increase<sizeof(Header)+sizeof(t_class)>	m_allocator;
	HeaderPtr												m_first;
	HeaderPtr												m_now;
	t_popinspector											m_inspector;

// private functions
//=================================================================================================
//!	destruct all
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void DestructAll()
{
	HeaderPtr		p = m_first;
	while( p != 0 )
	{
		if( p->m_constructed == true )
		{
			( ( t_class* )( p + 1 ) )->~t_class();
			p->m_constructed = false;
		}		
		p	= p->m_next;
	}
}	
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
Stackdata() : 
		m_now( 0 ) , 
		m_first( 0 )
{
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
~Stackdata()
{
	DestructAll();
	m_allocator.Deallocate();
}
//=================================================================================================
//!	set poolsize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void SetPoolSize
		(
		uint32		poolnum
		)
{
	m_allocator.SetPoolSize( poolnum );
}
//=================================================================================================
//!	reset
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void Reset()
{
	while( m_now != 0 )
	{
		Pop();
	}
}
//=================================================================================================
//!	push
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void Push()
{
	HeaderPtr*		nextptr	= m_now == 0 ? &m_first : &m_now->m_next; 
	if( *nextptr == 0 )
	{
		HeaderPtr	p = (HeaderPtr)m_allocator.Allocate();
		p->m_constructed	= false;
		p->m_prev			= m_now;
		p->m_next			= 0;
		*nextptr			= p;
		m_now				= p;
	}
	else
		m_now	= *nextptr;
	
	if( m_now->m_constructed == false )
	{
		new( (void*)( m_now + 1 ) )t_class();
		m_now->m_constructed = true;
	}
}
//=================================================================================================
//!	pop
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void Pop()
{
	cb_assert( m_now != 0 , "pop error." );
	if( m_now == 0 )
		return;
	if( true == m_inspector.InspectorPop( ( ( t_class* )( m_now + 1 ) ) ) )
	{
		( ( t_class* )( m_now + 1 ) )->~t_class();
		m_now->m_constructed = false;
	}
	m_now	= m_now->m_prev;
}
//=================================================================================================
//!	ref operator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
const t_class* operator->()const
{
	cb_assert( m_now != 0 , "empty data accessed." );
	return (t_class*)( m_now + 1 );
}
//=================================================================================================
//!	ref operator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
t_class* operator->()
{
	cb_assert( m_now != 0 , "empty data accessed." );
	return (t_class*)( m_now + 1 );
}
//=================================================================================================
//!	ref operator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
const t_class& operator*()const
{
	cb_assert( m_now != 0 , "empty data accessed." );
	return *(t_class*)( m_now + 1 );
}
//=================================================================================================
//!	ref operator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
t_class& operator*()
{
	cb_assert( m_now != 0 , "empty data accessed." );
	return *(t_class*)( m_now + 1 );
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
