/*************************************************************************************************/
/*!
   	@file		PathCubic.h
	@author 	Fanzo
 	@date 		2008/5/6
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iPathSegment.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"PathCubic_bs" class 
**************************************************************************************************/
class PathCubic_bs :
	public IPathSegment
{
	cb_copy_impossible( PathCubic_bs );

// variable member
private:
	float	m_samplenum;
	float	m_a[2] , m_b[2] , m_c[2] , m_d[2];

// private functions
private:
//=================================================================================================
//!	get optimum samplenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void UpdateSamplenum()
{
	if( m_a[0]==0.0f && m_a[1]==0.0f )
	{
		if( m_b[0]==0.0f && m_b[0]==0.0f )
		{
			m_samplenum	= 0.0f;
			return;
		}
		else
		{
			float	h	= 2.0f * sqrtf( cb_pathsegment_max_accident_error / sqrtf( m_b[0]*m_b[0]+m_b[1]*m_b[1] ) );
			m_samplenum	= 1.0f / h;
			return;
		}
	}
	// calc sample
	float	t[2];
	{
		fvector2	ss	= SecondOrderDifferential( 0.0f );
		t[0]	= ss.x * ss.x + ss.y * ss.y;
	}
	{
		fvector2	ss	= SecondOrderDifferential( 1.0f );
		t[1]	= ss.x * ss.x + ss.y * ss.y;
	}
	float	tt = t[0] > t[1] ? t[0] : t[1];
	float	h = sqrtf( 8.0f * cb_pathsegment_max_accident_error / sqrtf( tt ) );
	m_samplenum	= 1.0f / h;
}
// "IPath" interface functions
public:		
//=================================================================================================
//!	IsExist
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call IsExist()
{
	if( m_a[0]==0.0f && m_a[1]==0.0f && m_b[0]==0.0f && m_b[1]==0.0f && m_c[0]==0.0f && m_c[1]==0.0f )
		return false;
	return true;
}
//=================================================================================================
//!	get optimum samplenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int cb_call GetOptimumSample
		(
		float	samplescale
		)
{
	int	num = ( int )( samplescale * m_samplenum );
	return num < 2 ? 2 : num;
}
//=================================================================================================
//!	get optimum length samplenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int cb_call GetOptimumLengthSample()
{
	return 16;
}
//=================================================================================================
//!	value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 cb_call Value
		(
		float	t
		)
{
	float	t_t		= t * t;
	float	t_t_t	= t_t * t;
	return fvector2
			(
			m_a[0] * t_t_t + m_b[0] * t_t + m_c[0] * t + m_d[0] , 
			m_a[1] * t_t_t + m_b[1] * t_t + m_c[1] * t + m_d[1]
			);
}
//=================================================================================================
//!	Differential
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 cb_call Differential
		(
		float	t
		)
{
	float	t_t		= t * t;
	return fvector2
			(
			3.0f * m_a[0] * t_t + 2.0f * m_b[0] * t + m_c[0] , 
			3.0f * m_a[1] * t_t + 2.0f * m_b[1] * t + m_c[1]
			);		
}
//=================================================================================================
//!	SecondOrderDifferential
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 cb_call SecondOrderDifferential
		(
		float	t
		)
{
	return fvector2
			(
			6.0f * m_a[0] * t + 2.0f * m_b[0] , 
			6.0f * m_a[1] * t + 2.0f * m_b[1]
			);		
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
PathCubic_bs() : m_samplenum( 0.0f )
{
	m_a[0]	= 0.0f;
	m_a[1]	= 0.0f;
	m_b[0]	= 0.0f;
	m_b[1]	= 0.0f;
	m_c[0]	= 0.0f;
	m_c[1]	= 0.0f;
	m_d[0]	= 0.0f;
	m_d[1]	= 0.0f;
}
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void InitializeParam
		(
		float			a0 , 
		float			b0 , 
		float			c0 , 
		float			d0 , 
		float			a1 , 
		float			b1 , 
		float			c1 , 
		float			d1 , 
		const faffine&	affine
		)
{
	int		i;
	for( i = 0 ; i < 2 ; i++ )
	{
		m_a[i]	= affine.m[i][0]*a0 + affine.m[i][1]*a1;
		m_b[i]	= affine.m[i][0]*b0 + affine.m[i][1]*b1;
		m_c[i]	= affine.m[i][0]*c0 + affine.m[i][1]*c1;
		m_d[i]	= affine.m[i][0]*d0 + affine.m[i][1]*d1 + affine.m[i][2];
	}
	UpdateSamplenum();
}
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void InitializeBezierC
		(
		const fvector2&		sp , 
		const fvector2&		h0p , 
		const fvector2&		h1p , 
		const fvector2&		tp , 
		const faffine&	affine
		)
{
	InitializeParam
		(
		-sp.x + 3.0f * h0p.x - 3.0f * h1p.x + tp.x , 
		3.0f * ( sp.x - 2.0f * h0p.x + h1p.x ) , 
		3.0f * ( -sp.x + h0p.x ) , 
		sp.x , 
		-sp.y + 3.0f * h0p.y - 3.0f * h1p.y + tp.y , 
		3.0f * ( sp.y - 2.0f * h0p.y + h1p.y ) , 
		3.0f * ( -sp.y + h0p.y ) , 
		sp.y , 
		affine
		);
}
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void InitializeBezierC
		(
		float			sx , 
		float			sy , 
		float			h0x , 
		float			h0y , 
		float			h1x , 
		float			h1y , 
		float			tx , 
		float			ty , 
		const faffine&	affine
		)
{
	InitializeParam
		(
		-sx + 3.0f * h0x - 3.0f * h1x + tx , 
		3.0f * ( sx - 2.0f * h0x + h1x ) , 
		3.0f * ( -sx + h0x ) , 
		sx , 
		-sy + 3.0f * h0y - 3.0f * h1y + ty , 
		3.0f * ( sy - 2.0f * h0y + h1y ) , 
		3.0f * ( -sy + h0y ) , 
		sy , 
		affine
		);
}
};
/**************************************************************************************************
"PathCubic" class 
**************************************************************************************************/
class PathCubic : 
	virtual public object_base , 
	public PathCubic_bs
{
// query
	query_begin();
	iface_hook( IPathSegment , IPathSegment_IID )
	query_end( object_base );
	
// variable member
private:

// private functions
private:

// "IPathCubic" interface functions
public:

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
PathCubic()
{
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
