/*************************************************************************************************/
/*!
   	@file		PaintGradRadial.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iPaint.h"
#include	"NormTable.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"PaintGradRadial" class 
**************************************************************************************************/
template<class t_interface>
class PaintGradRadial_bs : 
	public t_interface
{
// member class
private:
	class ColorTbl
	{
	public:
		float	m_rate;
		rgba	m_color;
	};
	class CalcColorTbl
	{
	public:
		float	m_length;
		rgba	m_color;
		bool operator<
			(
			const CalcColorTbl&	obj
			)const
		{
			if( m_length < obj.m_length )
				return true;
			return false;
		}
		bool operator>
			(
			const CalcColorTbl&	obj
			)const
		{
			if( m_length > obj.m_length )
				return true;
			return false;
		}
	};

// variable member
private:
	// param
	fvector2				m_center_pos;
	float					m_vector_length;
	iNormTable_f			m_blendtbl;
	Array<ColorTbl>			m_colortbl;
	faffine					m_transform;
	
	// calc
	Array<CalcColorTbl>		m_calc_colortbl;

	// render
	pixelformat				m_destformat;
	
// private functions
private:
//=================================================================================================
//!	get blendtbl
//!	@retval			---
//-------------------------------------------------------------------------------------------------
const float* GetBlendTbl()
{
	if( m_blendtbl == false )
		return TableSinR_f();
	return m_blendtbl->GetNormTable();
}
//=================================================================================================
//!	update calc color tbl
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void UpdateCalcColorTbl()
{
	int		off , num = m_colortbl.GetDatanum();
	m_calc_colortbl.Resize( num );
	for( off = 0 ; off < num ; off++ )
	{
		m_calc_colortbl[ off ].m_color	= m_colortbl[ off ].m_color;
		m_calc_colortbl[ off ].m_length	= m_colortbl[ off ].m_rate * m_vector_length;
	}
	BubbleSort( m_calc_colortbl.GetPtr() , num );
}
//=================================================================================================
//!	xy->l
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float xy_to_l
		(
		const fvector2&	xy , 
		const fvector2& c
		)
{
	float	dx	= xy.x - c.x;
	float	dy	= xy.y - c.y;
	return sqrtf( dx * dx + dy * dy );
}
//=================================================================================================
//!	l->d
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float l_to_d
		(
		float		l , 
		float		ld
		)
{
	return sqrtf( l * l - ld * ld );
}
//=================================================================================================
//!	d->off
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int d_to_off
		(
		float	d , 
		float	ds , 
		float	dt , 
		int		len
		)
{
	return ( int )floorf( ( ( d - ds ) * len / ( dt - ds ) ) + 0.5f );
}
//=================================================================================================
//!	xy->d
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float xy_to_d
		(
		const fvector2&	xy , 
		const fvector2& p
		)
{
	return ( xy - p ).Length();
}
//=================================================================================================
//!	d -> xy
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 d_to_xy
		(
		float			d , 
		float			ds , 
		float			dt , 
		const fvector2&	sp , 
		const fvector2&	tp
		)
{
	float	r = ( d - ds ) / ( dt - ds );
	return sp + ( tp - sp ) * r;
}
//=================================================================================================
//!	l->xy
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 l_to_xy
		(
		float			l , 
		float			ld , 
		float			ds , 
		float			dt , 
		const fvector2&	sp , 
		const fvector2&	tp
		)
{
	float d	= l_to_d( l , ld );
	return d_to_xy( d , ds , dt , sp , tp );
}
//=================================================================================================
//!	xy->off
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int xy_to_off
		(
		const fvector2&	xy , 
		const fvector2& sp , 
		const fvector2& tp , 
		int				len
		)
{
	return ( int )floorf( (len * ( xy - sp ).Length() / ( tp - sp ).Length() ) + 0.5f );
}
//=================================================================================================
//!	l->off
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int l_to_off
		(
		float		l , 
		float		ds , 
		float		dt , 
		float		ld , 
		int			len
		)
{
	float	d = l_to_d( l , ld );
	return d_to_off( d , ds , dt , len );
}
//=================================================================================================
//!	render left
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void RenderSegment
		(
		pixelformat			format , 
		void*				dest , 
		int					len , 
		const fvector2&		p , 
		fvector2			sp , 
		fvector2			tp
		)
{
	float	ds	= xy_to_d( sp , p );
	float	dt	= xy_to_d( tp , p );
	bool	right	= true;
	if( ds > dt )
	{
		swap( &sp , &tp );
		swap( &ds , &dt );
		right	= false;
	}	
	float	ld	= xy_to_l( p , m_center_pos );
	float	ls	= xy_to_l( sp , m_center_pos );
	float	lt	= xy_to_l( tp , m_center_pos );
	
	int				pixelbyte	= get_pixel_byte( format );
	int				tblnum		= m_calc_colortbl.GetDatanum();
	CalcColorTbl*	cc			= &m_calc_colortbl[ 0 ];
	int				sx			= 0;
	
	// before
	float	llt = lt < cc->m_length ? lt : cc->m_length;
	if( ls < llt )
	{
		int		tx = ( llt == lt ) ? len : l_to_off( llt , ds , dt , ld , len );
		tx	= tx > len ? len : tx;
		if( sx < tx )
			pp_blender_onezero_c( to_pp_format( format ) , ( uint8* )dest + ( right == true ? sx : ( len - tx ) ) * pixelbyte , tx - sx , to_pp_color( cc->m_color ) );
		sx	= tx;
		ls	= llt;
	}
	// center
	const float*	blendtbl = GetBlendTbl();
	int		tbloff;
	for( tbloff = 0 ; tbloff < tblnum - 1 ; tbloff++ )
	{
		llt = lt < (cc+1)->m_length ? lt : (cc+1)->m_length;
		if( ls < llt )
		{
			int		tx = ( llt == lt ) ? len : l_to_off( llt , ds , dt , ld , len );
			tx	= tx > len ? len : tx;
			if( sx < tx )
			{
				fvector2	ssp	= sp + ( tp - sp ) * ( float )sx / ( float )len - m_center_pos;
				fvector2	ttp	= sp + ( tp - sp ) * ( float )tx / ( float )len - m_center_pos;
//				fvector2	ttp	= l_to_xy( llt , ld , ds , dt , sp , tp ) - m_center_pos;
				pp_gradation_radial_f
						( 
						to_pp_format( format ) , 
						( uint8* )dest + ( right == true ? sx : ( len - tx ) ) * pixelbyte , 
						tx - sx , 
						ssp.x , 
						ssp.y , 
						ttp.x , 
						ttp.y , 
						to_pp_color( cc->m_color ) , 
						to_pp_color( (cc+1)->m_color ) , 
						cc->m_length , 
						(cc+1)->m_length , 
						blendtbl , 
						right == true ? false : true
						);
			}
			sx	= tx;
			ls	= llt;
		}
		cc++;	
	}
	// after
	if( sx < len )
		pp_blender_onezero_c( to_pp_format( format ) , ( uint8* )dest + ( right == true ? sx : 0 ) * pixelbyte , len - sx , to_pp_color( cc->m_color ) );
}
//=================================================================================================
//!	get P
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 GetP
		(
		const fvector2&		sp , 
		const fvector2&		tp , 
		const fvector2&		c
		)
{
	fvector3	sc	= sp - c;
	fvector3	ts	= tp - sp;
	fvector3	cp_t	= ts.Outer( sc ).Outer( ts );
	fvector2	cp_t2( cp_t.x , cp_t.y );
	float		cp_l	= cp_t2.Length();
	if( cp_l == 0.0f )
		return m_center_pos;
	fvector2	cp	= cp_t2 / cp_l;
	cp	= sc.Inner( cp ) * cp;
	return cp + c;
}
//=================================================================================================
//!	render
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Render
		(
		pixelformat			format , 
		void				*dest , 
		int					len , 
		const fvector2&		sp , 
		const fvector2&		tp
		)
{
	fvector2	p = GetP( sp , tp , m_center_pos );
	fvector2	sp_vec	= sp - p;
	fvector2	tp_vec	= tp - p;
	
	if( sp_vec.Inner( tp_vec ) >= 0.0f )
	{
		RenderSegment( format , dest , len , p , sp , tp );
	}
	else
	{
		int		off = xy_to_off( p , sp , tp , len );
		off = off < 0 ? 0 : off > len ? len : off;
		
		int		pixelbyte	= get_pixel_byte( format );
		if( off != 0 )
			RenderSegment( format , dest , off , p , sp , p );
		if( off < len )
			RenderSegment( format , ( uint8* )dest + off * pixelbyte , len - off , p , p , tp );
	}
}
// "IPaint" interface functions
//=================================================================================================
IPaint::Type cb_call PaintType()
{
	return IPaint::Image;
}
//=================================================================================================
rgba cb_call PaintColor()
{
	return rgba();
}
//=================================================================================================
pixelformat	cb_call PaintImageFormat()
{
	return m_destformat;
}
//=================================================================================================
bool cb_call BeginPaintImage()
{
	return true;
}
//=================================================================================================
void cb_call PaintImage
		(
		void				*image , 
		int					len , 
		const fvector2&		sp , 
		const fvector2&		tp
		)
{
	Render( m_destformat , image , len , m_transform.Transform(sp) , m_transform.Transform(tp) );
}
//=================================================================================================
void cb_call EndPaintImage()
{
}
// "IPaintGradRadial" interface functions
public:
//=================================================================================================
void cb_call SetTransform
		(
		const faffine&	trans
		)
{
	m_transform	= trans;
}
//=================================================================================================
faffine cb_call GetTransform()
{
	return m_transform;
}
//=================================================================================================
bool cb_call SetGradationVector
		(
		const fvector2	&center_pos , 
		float			length
		)
{
	if( length <= 0.0f )
		return false;
	m_center_pos	= center_pos;
	m_vector_length	= length;
	UpdateCalcColorTbl();
	return true;
}
//=================================================================================================
void cb_call GetGradationVector
		(
		fvector2	*center_pos , 
		float		*length
		)
{
	if( center_pos != 0 )	*center_pos = m_center_pos;
	if( length != 0 )		*length		= m_vector_length;
}
//=================================================================================================
bool cb_call SetColorTable
		(
		int			num , 
		const float	rate[] ,		//!< [in] it need to be 0.0 - 1.0
		const rgba	color[]
		)
{
	if( num <= 0 )
		return false;
		
	m_colortbl.Resize( num );
	int		off;
	for( off = 0 ; off < num ; off++ )
	{
		m_colortbl[ off ].m_rate	= rate[ off ];
		m_colortbl[ off ].m_color	= color[ off ];
	}
	UpdateCalcColorTbl();
	return true;
}
//=================================================================================================
int cb_call GetColorTableNum()
{
	return m_colortbl.GetDatanum();
}
//=================================================================================================
void cb_call GetColorTable
		(
		float	rate[] , 
		rgba	color[]
		)
{
	int		off , num = m_colortbl.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		rate[off]	= m_colortbl[off].m_rate;
		color[off]	= m_colortbl[off].m_color;
	}
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
PaintGradRadial_bs() : 
		m_vector_length( 1.0f ) , 
		m_destformat( rgba_pixelformat )
{
	float	rate[] = { 0.0f , 0.5f , 1.0f };
	rgba	color[] = { rgba( 0 , 0 , 0 ) , rgba( 255 , 0 , 0 ) , rgba( 255 , 255 , 255 ) };
	SetColorTable( sizeof( rate ) / sizeof( rate[ 0 ] ) , rate , color );
//	SetGradationVector( fvector2( 50.0f , 0.0f ) , fvector2( 60.0f , 0.0f ) );
//	SetGradationVector( fvector2( 50.0f , 50.0f ) , fvector2( 51.0f , 51.0f ) );
	SetGradationVector( fvector2( 100.0f , 100.0f ) , 100.0f );
}
//=================================================================================================
//!	set interpolate table
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetInterpolateTable
		(
		iNormTable_f&		interpolate_tbl
		)
{
	if( interpolate_tbl == false )
		return;
	m_blendtbl	= interpolate_tbl;
}
};
/**************************************************************************************************
"PaintGradRadial" class 
**************************************************************************************************/
class PaintGradRadial : 
	public PaintGradRadial_bs<IPaintGradRadial> , 
	virtual public object_base 
{
// query
	query_begin();
	iface_hook( IPaint , IPaint_IID )
	iface_hook( IPaintGradRadial , IPaintGradRadial_IID )
	query_end( object_base );
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
