/*************************************************************************************************/
/*!
   	@file		outlinegenstroke.h
	@author 	Fanzo
 	@date 		2008/3/10
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iOutlineGen.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"OutlineGenStroke_bs" class 
**************************************************************************************************/
template< class t_interface>
class OutlineGenStroke_bs : 
	public t_interface
{
// variable member
private:
	float			m_width_r2;

	iJoint			m_joint;
	iCap			m_start_cap;
	iCap			m_end_cap;

	// work
	instance<PathLine>			m_line_ps;
	PathSegmentSamplerStroke	m_sampler;
	bool						m_close;
	iOutline					m_outline;
	OutlineNodePtr*				m_node;
	float						m_samplescale;
	
	fvector2		m_lpos , m_lvec , m_lw0 , m_lw1;
	bool			m_ff;
	fvector2		m_fpos , m_fvec , m_fw0 , m_fw1;
	
// private functions
private:
//=================================================================================================
//!	Initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void InitializePath
		(
		IPathSegment*	ps
		)
{
	GetStrokeEdge( ps , 0.0f , m_width_r2 , &m_fpos , &m_fvec , &m_fw0 , &m_fw1 );
	if( m_close == false )
		m_node = m_start_cap->InsertCap( m_outline , m_node , -m_fvec , m_fw1 , m_fw0 , m_samplescale );
}
//=================================================================================================
//!	FinalizePath
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void FinalizePath()
{
	if( m_close == false )
		m_node = m_end_cap->InsertCap( m_outline , m_node , m_lvec , m_lw0 , m_lw1 , m_samplescale );
	else
		SetSegmentLoop();
}
//=================================================================================================
//!	SetSegmentLoop
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetSegmentLoop()
{
	if( m_fpos != m_lpos )
	{
		fvector2	v = m_fpos - m_lpos;
		m_line_ps->InitializeParam( v.x , m_lpos.x , v.y , m_lpos.y , faffine() );
		GenerateOutline( (iPathSegment)m_line_ps );
	}
	m_node = m_joint->InsertJoint( m_outline , m_node , m_lpos , m_lvec , m_lw0 , m_lw1 , m_fvec , m_fw0 , m_fw1 , m_samplescale );
}
// "IOutlineGen" interface functions
public:
//=================================================================================================
//!	set samplescale
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetSampleScale
		(
		float		samplescale
		)
{
	m_samplescale	= samplescale;
}
//=================================================================================================
//!	begin
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call BeginOutline
		(
		iOutline	&outline , 
		bool		close
		)
{
	cb_assert( m_outline == false , L"Begin called before End." );
	m_outline		= outline;
	m_close			= close;
	m_ff			= false;
	OutlineSeg*	outlineinfo	= m_outline->CreateOutline();
	m_node	= &outlineinfo->m_node;
}
//=================================================================================================
//!	gen outline
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call GenerateOutline
		(
		IPathSegment*	ps
		)
{
	cb_assert( m_outline == true , L"Generate called before Begin." );
	if( ps->IsExist() == false )
		return;

	// init
	if( m_ff == false )
	{
		m_ff	= true;
		InitializePath( ps );
	}
	// joint
	else
	{
		fvector2	pos , w0 , w1 , vec;
		GetStrokeEdge( ps , 0.0f , m_width_r2 , &pos , &vec , &w0 , &w1 );
		m_node = m_joint->InsertJoint( m_outline , m_node , m_lpos , m_lvec , m_lw0 , m_lw1 , vec , w0 , w1 , m_samplescale );
	}
	// segment
	m_node = m_sampler.Sampling( m_outline , m_node , ps , 0.0f , 1.0f , m_samplescale );
	GetStrokeEdge( ps , 1.0f , m_width_r2 , &m_lpos , &m_lvec , &m_lw0 , &m_lw1 );
}
//=================================================================================================
//!	end
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call EndOutline()
{
	cb_assert( m_outline == true , L"End called before Begin." );
	
	if( m_ff == true )
		FinalizePath();
	m_outline.release();
	m_node	= 0;
}
// "IOutlineGenStroke" interface
public:
//=================================================================================================
//!	set width
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetStrokeWidth
		(
		float	w
		)
{
	m_width_r2	= w / 2.0f;
	m_sampler.SetWidth( m_width_r2 );
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
OutlineGenStroke_bs() :
		m_width_r2( 0.5f ) , 
		m_ff( false ) , 
		m_node( 0 ) , 
		m_close( false ) , 
		m_samplescale( 1.0f )
{
	m_joint			= instance<JointBevel>();
	m_start_cap		= instance<CapFlat>();
	m_end_cap		= instance<CapFlat>();
	m_sampler.SetWidth( m_width_r2 );
}
//=================================================================================================
//!	set inner bridge type
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetInnerBridgeType
		(
		InnerBridgeType	type
		)
{
	m_sampler.SetInnerBridgeType( type );
}
//=================================================================================================
//!	get width
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float cb_call GetWidth()const
{
	return m_width_r2 * 2.0f;
}
//=================================================================================================
//!	set joint
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetJoint
		(
		iJoint&		joint
		)
{
	m_joint	= joint;
}
//=================================================================================================
//!	get joint
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iJoint cb_call GetJoint()
{
	return m_joint;
}
//=================================================================================================
//!	set cap
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetCap
		(
		iCap&		start_cap , 
		iCap&		end_cap
		)
{
	m_start_cap	= start_cap;
	m_end_cap	= end_cap;
}
//=================================================================================================
//!	get cap
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call GetCap
		(
		iCap		*start_cap , 
		iCap		*end_cap
		)
{
	if( 0 != start_cap )	*start_cap	= m_start_cap;
	if( 0 != end_cap )		*end_cap	= m_end_cap;
}
};

/**************************************************************************************************
"OutlineGenStroke" class 
**************************************************************************************************/
class OutlineGenStroke : 
	public OutlineGenStroke_bs<IOutlineGenStroke> , 
	virtual public object_base
{
// query
	query_begin();
	iface_hook( IOutlineGen , IOutlineGen_IID )
	iface_hook( IOutlineGenStroke , IOutlineGenStroke_IID )
	query_end( object_base );
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
