/*************************************************************************************************/
/*!
   	@file		NormFunctionLinear.h
	@author 	Fanzo
 	@date 		2008/4/9
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iNormFunction.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"NormFunctionLinear" class 
**************************************************************************************************/
class NormFunctionLinear : 
	virtual public object_base , 
	public INormFunction
{
	query_begin();
	iface_hook( INormFunction , INormFunction_IID )
	query_end( object_base );
	
// variable member
private:
	//f(x) = a * x + b
	float		m_a;
	float		m_b;

// "INormFunction" interface functions
public:
//=================================================================================================
//!	GetNormalizedValue
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float cb_call GetNormalizedValue
		(
		float		n		//!< [in] 0.0 - 1.0
		)
{
	//f(x) = a * x + b
	return m_a * n + m_b;
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
NormFunctionLinear()
{
	SetCoefficient( fvector2( 0.0f , 1.0f ) , fvector2( 1.0f , 0.0f ) );
}
//=================================================================================================
//!	set coeff( f(x) = a * x + b )
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetCoefficient
		(
		float		a , 
		float		b 
		)
{
	m_a	= a;
	m_b	= b;
}
//=================================================================================================
//!	get coeff( f(x) = a * x + b )
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call GetCoefficient
		(
		float		*a , 
		float		*b
		)const
{
	if( a != 0 )	*a	= m_a;
	if( b != 0 )	*b	= m_b;
}
//=================================================================================================
//!	set start val
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call SetCoefficient
		(
		const fvector2&		p1 , 
		const fvector2&		p2
		)
{
	if( p1.x == p2.x )
		return false;
	m_a	= ( p2.y - p1.y ) / ( p2.x - p1.x );
	m_b	= ( p2.x * p1.y - p1.x * p2.y ) / ( p2.x - p1.x );
	return true;
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
