/*************************************************************************************************/
/*!
   	@file		NormFunctionBicubic.h
	@author 	Fanzo
 	@date 		2008/4/12
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"NormFunctionBicubic" class 
**************************************************************************************************/
class NormFunctionBicubic : 
	virtual public object_base , 
	public INormFunction
{
	query_begin();
	iface_hook( INormFunction , INormFunction_IID )
	query_end( object_base );
	
// "INormFunction" interface functions
public:
//=================================================================================================
//!	GetNormalizedValue
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float cb_call GetNormalizedValue
		(
		float		n		//!< [in] 0.0 - 1.0
		)
{
	if( 0.0f <= n && n < 1.0f )
	{
		return 1.0f - 2.0f * abs( n ) * abs( n ) + abs( n ) * abs( n ) * abs( n );
	}
	else if( 1.0f <= n && n <= 2.0f )
	{
		return 4.0f - 8.0f * abs( n ) + 5.0f * abs( n ) * abs( n ) - abs( n ) * abs( n ) * abs( n );
	}
	else
		return 0.0f;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
NormFunctionBicubic()
{
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
