/*************************************************************************************************/
/*!
   	@file		JointMiter.h
	@author 	Fanzo
 	@date 		2008/5/27
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"JointMiter" class 
**************************************************************************************************/
class JointMiter : 
	virtual public object_base , 
	public IJoint
{
	query_begin();
	iface_hook( IJoint , IJoint_IID )
	query_end( object_base );
	
// variable member
private:
	float	m_min_cos;
	
// private functions
private:
//=================================================================================================
//!	get miter pos
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 GetMiterPos
		(
		const fvector2&		p1 , 
		const fvector2&		p2 , 
		const fvector2&		n1 , 
		const fvector2&		n2
		)
{
	float	inner = n1.Inner( n2 );
	float	outer = n1.Outer( n2 );
	if( inner >= m_min_cos )
	{
		inner = m_min_cos;
		outer = outer >= 0.0f ? sqrtf( 1.0f - inner * inner ) : -sqrtf( 1.0f - inner * inner );
	}
	
	fvector2	cp	= ( p1 + p2 ) / 2.0f;
	float		cl	= ( n1 + n2 ).Length();
	if( cl == 0.0f )
		return cp;
	fvector2	cn	= ( n1 + n2 ) / cl;
	float		l	= ( p2 - p1 ).Length();
	
	fvector2	p = cp + cn * l * -outer / ( 2.0f * ( 1.0f - inner ) );
	return p;
}

// "IJoint" interface functions
public:
//=================================================================================================
//!	insert joint
//!	@retval			last node pointer
//-------------------------------------------------------------------------------------------------
OutlineNodePtr* cb_call InsertJoint
		(
		iOutline			&outline ,
		OutlineNodePtr*		node , 
		const fvector2&		pos , 
		const fvector2&		s_vec ,
		const fvector2&		s_w0 ,
		const fvector2&		s_w1 ,
		const fvector2&		t_vec ,
		const fvector2&		t_w0 ,
		const fvector2&		t_w1 , 
		float				samplescale
		)
{
	if( node == 0 )
		return node;
	float	out	= s_vec.Outer( t_vec );
	if( out == 0.0f )
	{
		node	= outline->InsertNode( node , s_w0 );
		node	= outline->InsertNode( node , GetMiterPos( s_w0 , t_w0 , s_vec , -t_vec ) );
		node	= outline->InsertNode( node , t_w0 );
		outline->InsertNode( node , s_w1 );
		outline->InsertNode( node , t_w1 );
	}
	else if( out > 0.0f )
	{
		node	= outline->InsertNode( node , s_w0 );
		node	= outline->InsertNode( node , GetMiterPos( s_w0 , t_w0 , s_vec , -t_vec ) );
		node	= outline->InsertNode( node , t_w0 );
		outline->InsertNode( node , s_w1 );
		outline->InsertNode( node , pos );
		outline->InsertNode( node , t_w1 );
	}
	else
	{
		node	= outline->InsertNode( node , s_w0 );
		node	= outline->InsertNode( node , pos );
		node	= outline->InsertNode( node , t_w0 );
		outline->InsertNode( node , s_w1 );
		outline->InsertNode( node , GetMiterPos( t_w1 , s_w1 , -t_vec , s_vec ) );
		outline->InsertNode( node , t_w1 );
	}
	return node;

/*

	if( node == 0 )
		return node;
	float	out	= s_vec.Outer( t_vec );
	
	if( out >= 0.0f )
	{
		node	= outline->InsertNode( node , s_w0 );
		node	= outline->InsertNode( node , GetMiterPos( s_w0 , t_w0 , s_vec , -t_vec ) );
		node	= outline->InsertNode( node , t_w0 );
		outline->InsertNode( node , s_w1 );
		outline->InsertNode( node , t_w1 );
	}
	else
	{
		node	= outline->InsertNode( node , s_w0 );
		node	= outline->InsertNode( node , t_w0 );
		outline->InsertNode( node , s_w1 );
		outline->InsertNode( node , GetMiterPos( t_w1 , s_w1 , -t_vec , s_vec ) );
		outline->InsertNode( node , t_w1 );
	}
	return node;
*/
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
JointMiter()
{
	m_min_cos	= cosf( PI_f / 10.0f );
}
//=================================================================================================
//!	set minimum rad
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetMinimumAngle
		(
		float		rad
		)
{
	if( rad > PI_f )
		rad = PI_f;
	if( rad < 0.1f )
		rad = 0.1f;
	m_min_cos	= cosf( rad );
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
