/*************************************************************************************************/
/*!
   	@file		matrix.h
	@author 	Fanzo
 	@date 		2008/2/29
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"fmatrix33" class 
**************************************************************************************************/
class fmatrix33
{
// variable member
public:
	float	m[ 3 ][ 3 ];

// private functions
private:
// protect functions
protected:
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
fmatrix33()
{
	set_unit();
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
fmatrix33
		(
		float	m00 , 
		float	m01 , 
		float	m02 , 
		float	m10 , 
		float	m11 , 
		float	m12 , 
		float	m20 , 
		float	m21 , 
		float	m22
		)
{
	m[ 0 ][ 0 ]	= m00;
	m[ 0 ][ 1 ]	= m01;
	m[ 0 ][ 2 ]	= m02;

	m[ 1 ][ 0 ]	= m10;
	m[ 1 ][ 1 ]	= m11;
	m[ 1 ][ 2 ]	= m12;

	m[ 2 ][ 0 ]	= m20;
	m[ 2 ][ 1 ]	= m21;
	m[ 2 ][ 2 ]	= m22;
}
//=================================================================================================
//!	get element
//!	@retval			---
//-------------------------------------------------------------------------------------------------
const float& elem
		(
		int		row , 
		int		column
		)const
{
	cb_assert( 0 <= row && row <= 3 , L"out of range accessed." );
	cb_assert( 0 <= column && column <= 3 , L"out of range accessed." );
	return m[ row ][ column ];
}
//=================================================================================================
//!	get element
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float& elem
		(
		int		row , 
		int		column
		)
{
	cb_assert( 0 <= row && row <= 3 , L"out of range accessed." );
	cb_assert( 0 <= column && column <= 3 , L"out of range accessed." );
	return m[ row ][ column ];
}
//=================================================================================================
//!	is unit matrix
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool is_unit()const
{
	int	r , c;
	for( r = 0 ; r < 3 ; r++ )
	{
		for( c = 0 ; c < 3 ; c++ )
		{
			if( r == c )
			{
				if( m[ r ][ c ] != 1.0f )
					return false;
			}
			else
			{
				if( m[ r ][ c ] != 0.0f )
					return false;
			}
		}
	}
	return true;
}
//=================================================================================================
//!	set unit matrix
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void set_unit()
{
	int		r;
	for( r = 0 ; r < 3 ; r++ )
	{
		m[ r ][ 0 ] = ( r==0 ) ? 1.0f : 0.0f;
		m[ r ][ 1 ] = ( r==1 ) ? 1.0f : 0.0f;
		m[ r ][ 2 ] = ( r==2 ) ? 1.0f : 0.0f;
	}
}
//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool operator==
		(
		const fmatrix33&	obj
		)const
{
	int		r;
	for( r = 0 ; r < 3 ; r++ )
	{
		int		c;
		for( c = 0 ; c < 3 ; c++ )
		{
			if( m[ r ][ c ] != obj.m[ r ][ c ] )
				return false;
		}
	}
	return true;
}
//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool fmatrix33::operator!=
		(
		const fmatrix33&	obj
		)const
{
	return ( *this == obj ) ? false : true;
}
//=================================================================================================
//!	add
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fmatrix33 operator+
		(
		const fmatrix33& obj
		)const
{
	fmatrix33	r;
	r.m[ 0 ][ 0 ] = m[ 0 ][ 0 ] + obj.m[ 0 ][ 0 ];
	r.m[ 0 ][ 1 ] = m[ 0 ][ 1 ] + obj.m[ 0 ][ 1 ];
	r.m[ 0 ][ 2 ] = m[ 0 ][ 2 ] + obj.m[ 0 ][ 2 ];
	r.m[ 1 ][ 0 ] = m[ 1 ][ 0 ] + obj.m[ 1 ][ 0 ];
	r.m[ 1 ][ 1 ] = m[ 1 ][ 1 ] + obj.m[ 1 ][ 1 ];
	r.m[ 1 ][ 2 ] = m[ 1 ][ 2 ] + obj.m[ 1 ][ 2 ];
	r.m[ 2 ][ 0 ] = m[ 2 ][ 0 ] + obj.m[ 2 ][ 0 ];
	r.m[ 2 ][ 1 ] = m[ 2 ][ 1 ] + obj.m[ 2 ][ 1 ];
	r.m[ 2 ][ 2 ] = m[ 2 ][ 2 ] + obj.m[ 2 ][ 2 ];
	return r;
}
//=================================================================================================
//!	add
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void operator+=
		(
		const fmatrix33& obj
		)
{
	m[ 0 ][ 0 ] += obj.m[ 0 ][ 0 ];
	m[ 0 ][ 1 ] += obj.m[ 0 ][ 1 ];
	m[ 0 ][ 2 ] += obj.m[ 0 ][ 2 ];
	m[ 1 ][ 0 ] += obj.m[ 1 ][ 0 ];
	m[ 1 ][ 1 ] += obj.m[ 1 ][ 1 ];
	m[ 1 ][ 2 ] += obj.m[ 1 ][ 2 ];
	m[ 2 ][ 0 ] += obj.m[ 2 ][ 0 ];
	m[ 2 ][ 1 ] += obj.m[ 2 ][ 1 ];
	m[ 2 ][ 2 ] += obj.m[ 2 ][ 2 ];
}
//=================================================================================================
//!	sub
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fmatrix33 operator-
		(
		const fmatrix33& obj
		)const
{
	fmatrix33	r;
	r.m[ 0 ][ 0 ] = m[ 0 ][ 0 ] - obj.m[ 0 ][ 0 ];
	r.m[ 0 ][ 1 ] = m[ 0 ][ 1 ] - obj.m[ 0 ][ 1 ];
	r.m[ 0 ][ 2 ] = m[ 0 ][ 2 ] - obj.m[ 0 ][ 2 ];
	r.m[ 1 ][ 0 ] = m[ 1 ][ 0 ] - obj.m[ 1 ][ 0 ];
	r.m[ 1 ][ 1 ] = m[ 1 ][ 1 ] - obj.m[ 1 ][ 1 ];
	r.m[ 1 ][ 2 ] = m[ 1 ][ 2 ] - obj.m[ 1 ][ 2 ];
	r.m[ 2 ][ 0 ] = m[ 2 ][ 0 ] - obj.m[ 2 ][ 0 ];
	r.m[ 2 ][ 1 ] = m[ 2 ][ 1 ] - obj.m[ 2 ][ 1 ];
	r.m[ 2 ][ 2 ] = m[ 2 ][ 2 ] - obj.m[ 2 ][ 2 ];
	return r;
}
//=================================================================================================
//!	sub
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void operator-=
		(
		const fmatrix33& obj
		)
{
	m[ 0 ][ 0 ] -= obj.m[ 0 ][ 0 ];
	m[ 0 ][ 1 ] -= obj.m[ 0 ][ 1 ];
	m[ 0 ][ 2 ] -= obj.m[ 0 ][ 2 ];
	m[ 1 ][ 0 ] -= obj.m[ 1 ][ 0 ];
	m[ 1 ][ 1 ] -= obj.m[ 1 ][ 1 ];
	m[ 1 ][ 2 ] -= obj.m[ 1 ][ 2 ];
	m[ 2 ][ 0 ] -= obj.m[ 2 ][ 0 ];
	m[ 2 ][ 1 ] -= obj.m[ 2 ][ 1 ];
	m[ 2 ][ 2 ] -= obj.m[ 2 ][ 2 ];
}
//=================================================================================================
//!	sub
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fmatrix33 operator-()const
{
	fmatrix33	r;
	r.m[ 0 ][ 0 ] = -m[ 0 ][ 0 ];
	r.m[ 0 ][ 1 ] = -m[ 0 ][ 1 ];
	r.m[ 0 ][ 2 ] = -m[ 0 ][ 2 ];
	r.m[ 1 ][ 0 ] = -m[ 1 ][ 0 ];
	r.m[ 1 ][ 1 ] = -m[ 1 ][ 1 ];
	r.m[ 1 ][ 2 ] = -m[ 1 ][ 2 ];
	r.m[ 2 ][ 0 ] = -m[ 2 ][ 0 ];
	r.m[ 2 ][ 1 ] = -m[ 2 ][ 1 ];
	r.m[ 2 ][ 2 ] = -m[ 2 ][ 2 ];
	return r;
}
//=================================================================================================
//!	mul
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fmatrix33 operator*
		(
		const fmatrix33&	obj
		)const
{
	fmatrix33	r;
	int		row , column;
	for( row = 0 ; row < 3 ; row++ )
	{
		for( column = 0 ; column < 3 ; column++ )
		{
			r.m[ row ][ column ] = m[ row ][ 0 ] * obj.m[ 0 ][ column ] + m[ row ][ 1 ] * obj.m[ 1 ][ column ] + m[ row ][ 2 ] * obj.m[ 2 ][ column ];
		}
	}
	return r;
}
//=================================================================================================
//!	mul
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void operator*=
		(
		const fmatrix33&	obj
		)
{
	*this = *this * obj;
}
//=================================================================================================
//!	inverse
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fmatrix33 Inverse()const
{
	float	det	= m[0][2] * ( m[1][0] * m[2][1] - m[1][1] * m[2][0] )
				+ m[1][2] * ( m[2][0] * m[0][1] - m[2][1] * m[0][0] )
				+ m[2][2] * ( m[0][0] * m[1][1] - m[0][1] * m[1][0] );
	fmatrix33	r;
	r.m[0][0]	= ( m[1][1] * m[2][2] - m[1][2] * m[2][1] ) / det;
	r.m[0][1]	= ( m[2][1] * m[0][2] - m[2][2] * m[0][1] ) / det;
	r.m[0][2]	= ( m[0][1] * m[1][2] - m[0][2] * m[1][1] ) / det;

	r.m[1][0]	= ( m[1][2] * m[2][0] - m[1][0] * m[2][2] ) / det;
	r.m[1][1]	= ( m[2][2] * m[0][0] - m[2][0] * m[0][2] ) / det;
	r.m[1][2]	= ( m[0][2] * m[1][0] - m[0][0] * m[1][2] ) / det;

	r.m[2][0]	= ( m[1][0] * m[2][1] - m[1][1] * m[2][0] ) / det;
	r.m[2][1]	= ( m[2][0] * m[0][1] - m[2][1] * m[0][0] ) / det;
	r.m[2][2]	= ( m[0][0] * m[1][1] - m[0][1] * m[1][0] ) / det;
	return r;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
