#ifndef __VECTOR_H__
#define __VECTOR_H__

#include <types.h>

template <class _T>
class Vector
{
public:
    Vector(void) : Data(0), Size(0) {}
    ~Vector(void) {delete[] Data;}
    _T& operator[](off_t i) const {return Data[i];}
    size_t getSize(void) const {return Size;}
    void   add(const _T& obj) {
        _T* NewData = new _T[Size + 1];
        for (off_t i = 0; i < Size; i++) NewData[i] = Data[i];
        NewData[Size++] = obj;
        delete[] Data;
        Data = NewData;
    }

private:
    _T*     Data;
    size_t Size;
};

#endif /* __VECTOR_H__ */
