#ifndef __SHELLCMD_H__
#define __SHELLCMD_H__

#include <string.h>
#include <vector.h>

class ShellCommand {
public:
    ShellCommand(const char* name) : Name(name) {}
    const String& getName(void) const {return Name;}

    virtual int execute(Vector<String> args) = 0;

private:    
    String Name;
};

class MemCommand : public ShellCommand {
public:
    MemCommand(void) : ShellCommand("mem") {}
    int execute(Vector<String> args);
};

class ClsCommand : public ShellCommand {
public:
    ClsCommand(void) : ShellCommand("cls") {}
    int execute(Vector<String> args);
};

#endif /* __SHELLCMD_H__ */

