#ifndef __SEMAPHORE_H__
#define __SEMAPHORE_H__

#include <queue.h>
#include <task.h>

class Semaphore {
public:
    Semaphore(uint32 max) : Value(0), MaxValue(max), WaitQueue(TaskCmp) {}

    void wait(void);
    void post(void);

    uint32 getValue(void) const {return Value;}

private:
    uint32 Value;
    uint32 MaxValue;

    TaskComparator TaskCmp;
    PriorityQueue  WaitQueue;
};

#endif /* __SEMAPHORE_H__ */
