/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.util;

import iax.protocol.util.ByteBufferException;

public class ByteBuffer {
    private static final int BYTE_BITS = 8;
    private static final int BYTE_MASK = 255;
    public static final int SIZE_8BITS = 1;
    public static final int SIZE_16BITS = 2;
    public static final int SIZE_32BITS = 4;
    private int pos;
    private byte[] buffer;

    public ByteBuffer(int i) throws ByteBufferException {
        if (i <= 0) {
            throw new ByteBufferException("ByteBuffer's length isn't greater than zero");
        }
        this.buffer = new byte[i];
        this.pos = 0;
    }

    public ByteBuffer(byte[] buff) {
        this.buffer = buff;
        this.pos = 0;
    }

    public int getRemaining() {
        return this.buffer.length - this.pos;
    }

    public boolean hasRemaining() {
        return this.pos <= this.buffer.length;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int get8bits() throws ByteBufferException {
        if (this.pos + 1 <= this.buffer.length) {
            byte result = this.buffer[this.pos];
            ++this.pos;
            return result;
        }
        throw new ByteBufferException("ByteBuffer index of bound");
    }

    public int get8bits(int pos) throws ByteBufferException {
        if (pos + 1 <= this.buffer.length) {
            byte result = this.buffer[pos];
            return result;
        }
        throw new ByteBufferException("ByteBuffer index of bound");
    }

    public int get16bits() throws ByteBufferException {
        if (this.pos + 2 <= this.buffer.length) {
            int result = 0;
            int i = 0;
            int j = 1;
            while (i < 2) {
                result += (this.buffer[this.pos + i] & 0xFF) << j * 8;
                ++i;
                --j;
            }
            this.pos += 2;
            return result;
        }
        throw new ByteBufferException("ByteBuffer index of bound");
    }

    public int get16bits(int pos) throws ByteBufferException {
        if (pos + 2 <= this.buffer.length) {
            int result = 0;
            int i = 0;
            int j = 1;
            while (i < 2) {
                result += (this.buffer[pos + i] & 0xFF) << j * 8;
                ++i;
                --j;
            }
            return result;
        }
        throw new ByteBufferException("ByteBuffer index of bound");
    }

    public long get32bits() throws ByteBufferException {
        if (this.pos + 4 <= this.buffer.length) {
            long result = 0L;
            int i = 0;
            int j = 3;
            while (i < 4) {
                result += (long)((this.buffer[this.pos + i] & 0xFF) << j * 8);
                ++i;
                --j;
            }
            this.pos += 4;
            return result;
        }
        throw new ByteBufferException("ByteBuffer index of bound");
    }

    public long get32bits(int pos) throws ByteBufferException {
        if (pos + 4 <= this.buffer.length) {
            long result = 0L;
            int i = 0;
            int j = 3;
            while (i < 4) {
                result += (long)((this.buffer[pos + i] & 0xFF) << j * 8);
                ++i;
                --j;
            }
            return result;
        }
        throw new ByteBufferException("ByteBuffer index of bound");
    }

    public byte[] getByteArray() throws ByteBufferException {
        if (this.pos <= this.buffer.length) {
            byte[] result = new byte[this.buffer.length - this.pos];
            System.arraycopy(this.buffer, this.pos, result, 0, result.length);
            this.pos += result.length;
            return result;
        }
        throw new ByteBufferException("ByteBuffer index of bound");
    }

    public byte[] getByteArray(int pos) throws ByteBufferException {
        if (pos <= this.buffer.length) {
            byte[] result = new byte[this.buffer.length - pos];
            System.arraycopy(this.buffer, pos, result, 0, result.length);
            return result;
        }
        throw new ByteBufferException("ByteBuffer index of bound");
    }

    public void put8bits(int value) throws ByteBufferException {
        if (this.pos + 1 <= this.buffer.length) {
            this.buffer[this.pos] = (byte)value;
            ++this.pos;
        } else {
            throw new ByteBufferException("ByteBuffer index of bound");
        }
    }

    public void put8bits(int value, int pos) throws ByteBufferException {
        if (pos + 1 > this.buffer.length) {
            throw new ByteBufferException("ByteBuffer index of bound");
        }
        this.buffer[pos] = (byte)value;
    }

    public void put16bits(int value) throws ByteBufferException {
        if (this.pos + 2 <= this.buffer.length) {
            int i = 0;
            int j = 1;
            while (i < 2) {
                this.buffer[this.pos + i] = (byte)(value >> j * 8 & 0xFF);
                ++i;
                --j;
            }
            this.pos += 2;
        } else {
            throw new ByteBufferException("ByteBuffer index of bound");
        }
    }

    public void put16bits(int value, int pos) throws ByteBufferException {
        if (pos + 2 <= this.buffer.length) {
            int i = 0;
            int j = 1;
            while (i < 2) {
                this.buffer[pos + i] = (byte)(value >> j * 8 & 0xFF);
                ++i;
                --j;
            }
        } else {
            throw new ByteBufferException("ByteBuffer index of bound");
        }
    }

    public void put32bits(long value) throws ByteBufferException {
        if (this.pos + 4 <= this.buffer.length) {
            int i = 0;
            int j = 3;
            while (i < 4) {
                this.buffer[this.pos + i] = (byte)(value >> j * 8 & 0xFFL);
                ++i;
                --j;
            }
            this.pos += 4;
        } else {
            throw new ByteBufferException("ByteBuffer index of bound");
        }
    }

    public void put32bits(long value, int pos) throws ByteBufferException {
        if (pos + 4 <= this.buffer.length) {
            int i = 0;
            int j = 3;
            while (i < 4) {
                this.buffer[pos + i] = (byte)(value >> j * 8 & 0xFFL);
                ++i;
                --j;
            }
        } else {
            throw new ByteBufferException("ByteBuffer index of bound");
        }
    }

    public void putByteArray(byte[] byteArray) throws ByteBufferException {
        if (this.pos + byteArray.length <= this.buffer.length) {
            System.arraycopy(byteArray, 0, this.buffer, this.pos, byteArray.length);
            this.pos += byteArray.length;
        } else {
            throw new ByteBufferException("ByteBuffer index of bound");
        }
    }

    public void putByteArray(byte[] byteArray, int pos) throws ByteBufferException {
        if (pos + byteArray.length > this.buffer.length) {
            throw new ByteBufferException("ByteBuffer index of bound");
        }
        System.arraycopy(byteArray, 0, this.buffer, pos, byteArray.length);
    }
}

