/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.user.command;

import iax.protocol.peer.Peer;
import iax.protocol.user.command.AnswerCall;
import iax.protocol.user.command.Exit;
import iax.protocol.user.command.HangupCall;
import iax.protocol.user.command.HoldCall;
import iax.protocol.user.command.MuteCall;
import iax.protocol.user.command.NewCall;
import iax.protocol.user.command.SendDTMF;
import iax.protocol.user.command.TransferCall;
import iax.protocol.user.command.UnHoldCall;
import iax.protocol.user.command.UnMuteCall;

public class UserCommandFacade {
    public static void answerCall(Peer peer, String callingNumber) {
        new AnswerCall(peer, callingNumber).execute();
    }

    public static void hangupCall(Peer peer, String calledNumber) {
        new HangupCall(peer, calledNumber).execute();
    }

    public static void holdCall(Peer peer, String calledNumber) {
        new HoldCall(peer, calledNumber).execute();
    }

    public static void newCall(Peer peer, String calledNumber) {
        new NewCall(peer, calledNumber).execute();
    }

    public static void exit(Peer peer) {
        new Exit(peer).execute();
    }

    public static void muteCall(Peer peer, String calledNumber) {
        new MuteCall(peer, calledNumber).execute();
    }

    public static void unHoldCall(Peer peer, String calledNumber) {
        new UnHoldCall(peer, calledNumber).execute();
    }

    public static void unMuteCall(Peer peer, String calledNumber) {
        new UnMuteCall(peer, calledNumber).execute();
    }

    public static void sendDTMF(Peer peer, String calledNumber, char tone) {
        new SendDTMF(peer, calledNumber, tone).execute();
    }

    public static void transferCall(Peer peer, String srcNumber, String dstNumber) {
        new TransferCall(peer, srcNumber, dstNumber).execute();
    }
}

