/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.user.command;

import iax.protocol.call.Call;
import iax.protocol.frame.ProtocolControlFrame;
import iax.protocol.peer.Peer;
import iax.protocol.user.command.UserCommand;

public class NewCall
implements UserCommand {
    private Peer peer;
    private String calledNumber;

    public NewCall(Peer peer, String calledNumber) {
        this.peer = peer;
        this.calledNumber = calledNumber;
    }

    public void execute() {
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        try {
            Call call = this.peer.newCall(this.calledNumber);
            ProtocolControlFrame newCallFrame = new ProtocolControlFrame(call.getSrcCallNo(), false, 0, 0L, call.getOseqno(), call.getIseqno(), false, 1);
            newCallFrame.setVersion(2);
            newCallFrame.setCalledNumber(this.calledNumber);
            newCallFrame.setCallingNumber(this.peer.getUserName());
            newCallFrame.setCapability(call.getAudioFactory().getCodec());
            newCallFrame.setFormat(call.getAudioFactory().getCodec());
            newCallFrame.setUserName(this.peer.getUserName());
            call.handleSendFrame(newCallFrame);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

