/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.peer.command.send;

import iax.protocol.frame.ProtocolControlFrame;
import iax.protocol.peer.Peer;
import iax.protocol.peer.command.send.PeerCommandSend;
import iax.protocol.util.Converter;
import iax.protocol.util.FrameUtil;

public class RegRel
implements PeerCommandSend {
    private Peer peer;
    private ProtocolControlFrame regauthFrame;

    public RegRel(Peer peer) {
        this.peer = peer;
        this.regauthFrame = null;
    }

    public RegRel(Peer peer, ProtocolControlFrame regauthFrame) {
        this.peer = peer;
        this.regauthFrame = regauthFrame;
    }

    public void execute() {
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        try {
            if (this.regauthFrame != null) {
                String userName = this.regauthFrame.getUserName();
                int auth = this.regauthFrame.getAuthMethods();
                String challenge = this.regauthFrame.getChallenge();
                if (userName.equals(this.peer.getUserName())) {
                    String password = this.peer.getPassword();
                    ProtocolControlFrame regrelFrame = new ProtocolControlFrame(1, false, this.regauthFrame.getSrcCallNo(), this.peer.getTimestamp(), this.regauthFrame.getIseqno(), this.regauthFrame.getOseqno() + 1, false, 17);
                    regrelFrame.setUserName(userName);
                    switch (auth) {
                        case 2: 
                        case 3: {
                            password = Converter.byteArrayToHexString(FrameUtil.md5(challenge.getBytes(), password.getBytes()));
                            regrelFrame.setMD5Result(password);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 1: {
                            regrelFrame.setMD5Result(password);
                            break;
                        }
                    }
                    this.peer.handleSendFrame(regrelFrame);
                }
            } else {
                ProtocolControlFrame regrelFrame = new ProtocolControlFrame(1, false, 0, this.peer.getTimestamp(), 0, 0, false, 17);
                regrelFrame.setUserName(this.peer.getUserName());
                this.peer.handleSendFrame(regrelFrame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

