/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.frame;

import iax.protocol.frame.Frame;
import iax.protocol.frame.FrameException;
import iax.protocol.util.ByteBuffer;

public class MiniFrame
extends Frame {
    private int timestamp;
    private byte[] data;
    protected static final int MINIFRAME_HEADER_LENGTH = 4;

    protected MiniFrame() {
    }

    public MiniFrame(int srcCallNo, int timestamp, byte[] data) {
        super(1, false, srcCallNo);
        this.timestamp = timestamp;
        this.data = data;
    }

    public MiniFrame(byte[] buffer) throws FrameException {
        super(1, buffer);
        try {
            byte[] aux = new byte[buffer.length - 2];
            System.arraycopy(buffer, 2, aux, 0, aux.length);
            ByteBuffer byteBuffer = new ByteBuffer(aux);
            this.timestamp = byteBuffer.get16bits();
            this.data = byteBuffer.getByteArray();
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(short timestamp) {
        this.timestamp = timestamp;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] serialize() throws FrameException {
        try {
            byte[] superInBytes = super.serialize();
            byte[] thisInBytes = new byte[4 + this.data.length];
            ByteBuffer byteBuffer = new ByteBuffer(2);
            byteBuffer.put16bits(this.timestamp);
            System.arraycopy(superInBytes, 0, thisInBytes, 0, superInBytes.length);
            System.arraycopy(byteBuffer.getBuffer(), 0, thisInBytes, superInBytes.length, byteBuffer.getBuffer().length);
            System.arraycopy(this.data, 0, thisInBytes, 4, this.data.length);
            return thisInBytes;
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }
}

