/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.call.state;

import iax.protocol.call.Call;
import iax.protocol.call.command.recv.CallCommandRecvFacade;
import iax.protocol.call.state.CallState;
import iax.protocol.frame.ControlFrame;
import iax.protocol.frame.DTMFFrame;
import iax.protocol.frame.Frame;
import iax.protocol.frame.MiniFrame;
import iax.protocol.frame.ProtocolControlFrame;
import iax.protocol.frame.VoiceFrame;

public class Up
extends CallState {
    private static Up instance;

    private Up() {
        instance = this;
    }

    public static Up getInstance() {
        if (instance != null) {
            return instance;
        }
        return new Up();
    }

    public void handleRecvFrame(Call call, Frame frame) {
        try {
            if (frame.getType() == 2) {
                ControlFrame controlFrame = (ControlFrame)frame;
                switch (controlFrame.getSubclass()) {
                    case 3: {
                        CallCommandRecvFacade.ringing(call, controlFrame);
                        break;
                    }
                }
            } else if (frame.getType() == 3) {
                ProtocolControlFrame protocolControlFrame = (ProtocolControlFrame)frame;
                protocolControlFrame.getSubclass();
                super.handleRecvFrame(call, frame);
            } else if (frame.getType() == 4) {
                VoiceFrame voiceFrame = (VoiceFrame)frame;
                CallCommandRecvFacade.voiceFullFrame(call, voiceFrame);
            } else if (frame.getType() == 5) {
                DTMFFrame dtmfFrame = (DTMFFrame)frame;
                CallCommandRecvFacade.dtmfFullFrame(call, dtmfFrame);
            } else if (frame.getType() == 1) {
                MiniFrame miniFrame = (MiniFrame)frame;
                CallCommandRecvFacade.voiceMiniFrame(call, miniFrame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleSendFrame(Call call, Frame frame) {
        try {
            if (frame.getType() == 3) {
                ProtocolControlFrame protocolControlFrame = (ProtocolControlFrame)frame;
                switch (protocolControlFrame.getSubclass()) {
                    case 34: {
                        call.sendFullFrameAndWaitForAck(protocolControlFrame);
                        break;
                    }
                    default: {
                        super.handleSendFrame(call, frame);
                        break;
                    }
                }
            } else if (frame.getType() == 4) {
                VoiceFrame voiceFrame = (VoiceFrame)frame;
                call.sendFullFrameAndWaitForAck(voiceFrame);
            } else if (frame.getType() == 1) {
                MiniFrame miniFrame = (MiniFrame)frame;
                call.sendFrameAndNoWait(miniFrame);
            } else if (frame.getType() == 5) {
                DTMFFrame dtmfFrame = (DTMFFrame)frame;
                call.sendFullFrameAndWaitForAck(dtmfFrame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

