/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.call.state;

import iax.protocol.call.Call;
import iax.protocol.call.command.recv.CallCommandRecvFacade;
import iax.protocol.call.state.CallState;
import iax.protocol.call.state.Linked;
import iax.protocol.call.state.Waiting;
import iax.protocol.frame.Frame;
import iax.protocol.frame.ProtocolControlFrame;

public class Initial
extends CallState {
    private static Initial instance;

    private Initial() {
        instance = this;
    }

    public static Initial getInstance() {
        if (instance != null) {
            return instance;
        }
        return new Initial();
    }

    public void handleRecvFrame(Call call, Frame frame) {
        try {
            if (frame.getType() == 3) {
                ProtocolControlFrame protocolControlFrame = (ProtocolControlFrame)frame;
                switch (protocolControlFrame.getSubclass()) {
                    case 1: {
                        call.bindCall(protocolControlFrame.getSrcCallNo());
                        call.setState(Linked.getInstance());
                        CallCommandRecvFacade.newCall(call, protocolControlFrame);
                        break;
                    }
                    default: {
                        super.handleRecvFrame(call, frame);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleSendFrame(Call call, Frame frame) {
        try {
            if (frame.getType() == 3) {
                ProtocolControlFrame protocolControlFrame = (ProtocolControlFrame)frame;
                switch (protocolControlFrame.getSubclass()) {
                    case 1: {
                        call.sendFullFrameAndWaitForRep(protocolControlFrame);
                        call.setState(Waiting.getInstance());
                        break;
                    }
                    default: {
                        super.handleSendFrame(call, frame);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

