/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.call.state;

import iax.protocol.call.Call;
import iax.protocol.call.command.recv.CallCommandRecvFacade;
import iax.protocol.call.state.Initial;
import iax.protocol.frame.Frame;
import iax.protocol.frame.ProtocolControlFrame;

public abstract class CallState {
    public void handleRecvFrame(Call call, Frame frame) {
        try {
            if (frame.getType() == 3) {
                ProtocolControlFrame protocolControlFrame = (ProtocolControlFrame)frame;
                switch (protocolControlFrame.getSubclass()) {
                    case 4: {
                        CallCommandRecvFacade.ack(call, protocolControlFrame);
                        break;
                    }
                    case 5: {
                        CallCommandRecvFacade.hangup(call, protocolControlFrame);
                        call.setState(Initial.getInstance());
                        call.endCall();
                        break;
                    }
                    case 10: {
                        call.setState(Initial.getInstance());
                        call.endCall();
                        break;
                    }
                    case 11: {
                        CallCommandRecvFacade.lagrq(call, protocolControlFrame);
                        break;
                    }
                    case 2: {
                        CallCommandRecvFacade.ping(call, protocolControlFrame);
                        break;
                    }
                    case 3: {
                        CallCommandRecvFacade.pong(call, protocolControlFrame);
                        break;
                    }
                    case 33: {
                        CallCommandRecvFacade.unsupport(call, protocolControlFrame);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleSendFrame(Call call, Frame frame) {
        try {
            if (frame.getType() == 3) {
                ProtocolControlFrame protocolControlFrame = (ProtocolControlFrame)frame;
                switch (protocolControlFrame.getSubclass()) {
                    case 4: {
                        call.sendFrameAndNoWait(protocolControlFrame);
                        break;
                    }
                    case 12: {
                        call.sendFullFrameAndWaitForAck(protocolControlFrame);
                        break;
                    }
                    case 5: {
                        call.sendFullFrameAndWaitForAck(protocolControlFrame);
                        call.setState(Initial.getInstance());
                        call.endCall();
                        break;
                    }
                    case 2: {
                        call.sendFullFrameAndWaitForRep(protocolControlFrame);
                        break;
                    }
                    case 28: {
                        call.sendFullFrameAndWaitForAck(protocolControlFrame);
                        call.holdCall();
                        break;
                    }
                    case 3: {
                        call.sendFullFrameAndWaitForAck(protocolControlFrame);
                        break;
                    }
                    case 29: {
                        call.sendFullFrameAndWaitForAck(protocolControlFrame);
                        call.unHoldCall();
                        break;
                    }
                    case 33: {
                        call.sendFullFrameAndWaitForAck(protocolControlFrame);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

