/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.call;

import iax.audio.AudioFactory;
import iax.audio.AudioListener;
import iax.audio.Player;
import iax.audio.PlayerException;
import iax.audio.Recorder;
import iax.audio.RecorderException;
import iax.protocol.call.CallException;
import iax.protocol.call.command.send.CallCommandSendFacade;
import iax.protocol.call.state.CallState;
import iax.protocol.call.state.Initial;
import iax.protocol.frame.Frame;
import iax.protocol.frame.FullFrame;
import iax.protocol.frame.MiniFrame;
import iax.protocol.peer.Peer;
import iax.protocol.peer.PeerException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

public class Call
implements AudioListener {
    public static final int TIMESTAMP_MINIFRAME_RESET = 65536;
    private final int SEQNO_MAXSIZE = 256;
    private final int RETRY_MAXCOUNT = 5;
    private final int RETRY_REFRESH = 1;
    private HashMap framesWaitingAck;
    private HashMap framesWaitingReply;
    private Player player;
    private Recorder recorder;
    private boolean playing = false;
    private CallState state;
    private int srcCallNo;
    private int destCallNo;
    private long srcTimestamp;
    private long srcTimestampMiniFrame;
    private int oseqno;
    private int iseqno;
    private String calledNumber;
    private boolean firstVoiceFrameSended;
    private Peer peer;
    private Timer pingTimer;
    private Timer retryTimer;
    private boolean hold;
    private boolean mute;
    private AudioFactory audioFactory;
    private String dtmfCode;

    public Call(Peer peer, int srcCallNo, AudioFactory audioFactory) throws CallException {
        this.peer = peer;
        this.srcCallNo = srcCallNo;
        this.audioFactory = audioFactory;
        this.hold = false;
        this.mute = false;
        this.framesWaitingAck = new HashMap();
        this.framesWaitingReply = new HashMap();
        try {
            this.player = audioFactory.createPlayer();
            this.recorder = audioFactory.createRecorder();
        }
        catch (Exception e) {
            throw new CallException(e);
        }
    }

    public Peer getPeer() {
        return this.peer;
    }

    public int getSrcCallNo() {
        return this.srcCallNo;
    }

    public int getDestCallNo() {
        return this.destCallNo;
    }

    public int getIseqno() {
        return this.iseqno;
    }

    public int getOseqno() {
        return this.oseqno;
    }

    public String getCalledNumber() {
        return this.calledNumber;
    }

    public long getTimestamp() {
        long now = Calendar.getInstance().getTimeInMillis();
        return now - this.srcTimestamp;
    }

    public long getTimestampMiniFrame() {
        long now = Calendar.getInstance().getTimeInMillis();
        return now - this.srcTimestampMiniFrame;
    }

    private synchronized void incIseqno(int value) {
        this.iseqno = value;
        if (this.iseqno == 256) {
            this.iseqno = 0;
        }
    }

    private synchronized void incOseqno(int value) {
        this.oseqno = value;
        if (this.oseqno == 256) {
            this.oseqno = 0;
        }
    }

    public boolean isFirstVoiceFrameSended() {
        return this.firstVoiceFrameSended;
    }

    public void firstVoiceFrameWasSended() {
        this.firstVoiceFrameSended = false;
    }

    public boolean isHold() {
        return this.hold;
    }

    public boolean isMute() {
        return this.hold;
    }

    public void startCall(String calledNumber) {
        this.iseqno = 0;
        this.oseqno = 0;
        this.destCallNo = 0;
        this.firstVoiceFrameSended = true;
        this.framesWaitingAck.clear();
        this.calledNumber = calledNumber;
        this.state = Initial.getInstance();
        this.srcTimestampMiniFrame = this.srcTimestamp = Calendar.getInstance().getTimeInMillis();
        this.retryTimer = new Timer();
        TimerTask retryTimerTask = new TimerTask(){

            public void run() {
                Call.this.retryFramesWaiting();
            }
        };
        this.retryTimer.schedule(retryTimerTask, 1000L, 1000L);
    }

    public void answeredCall() {
        this.peer.answeredCall(this);
        this.startRecorder();
    }

    public void ringingCall() {
        this.peer.ringingCall(this);
    }

    public void bindCall(int destCallNo) {
        this.destCallNo = destCallNo;
        this.peer.bindCall(this);
    }

    public void endCall() {
        this.retryTimer.cancel();
        this.player.stop();
        this.recorder.stop();
        this.peer.endCall(this);
    }

    public void holdCall() {
        if (!this.hold) {
            this.hold = true;
            this.player.stop();
            try {
                this.player = this.audioFactory.createPlayer();
            }
            catch (PlayerException e) {
                e.printStackTrace();
            }
            if (!this.mute) {
                this.recorder.stop();
                try {
                    this.recorder = this.audioFactory.createRecorder();
                }
                catch (RecorderException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void unHoldCall() {
        if (this.hold) {
            this.player.play();
            if (!this.mute) {
                this.recorder.record(this);
            }
            this.hold = false;
        }
    }

    public void muteCall() {
        if (!this.mute) {
            this.mute = true;
            this.recorder.stop();
            try {
                this.recorder = this.audioFactory.createRecorder();
            }
            catch (RecorderException e) {
                e.printStackTrace();
            }
        }
    }

    public void unMuteCall() {
        if (this.mute) {
            this.recorder.record(this);
            this.mute = false;
        }
    }

    public synchronized void resetTimestampMiniFrame() {
        this.srcTimestampMiniFrame = Calendar.getInstance().getTimeInMillis();
    }

    public void ping() {
        CallCommandSendFacade.ping(this);
    }

    public void setState(CallState state) {
        this.state = state;
    }

    public void handleRecvFrame(FullFrame fullFrame) {
        if (fullFrame.getFrameType() != 3) {
            this.incIseqno(fullFrame.getOseqno() + 1);
        } else if (fullFrame.getSubclass() != 4) {
            this.incIseqno(fullFrame.getOseqno() + 1);
        }
        this.incOseqno(fullFrame.getIseqno());
        this.state.handleRecvFrame(this, fullFrame);
    }

    public void handleRecvFrame(MiniFrame frame) {
        this.state.handleRecvFrame(this, frame);
    }

    public void handleSendFrame(Frame frame) {
        this.state.handleSendFrame(this, frame);
    }

    public synchronized void ackedFrame(long timeStamp) {
        this.framesWaitingAck.remove(timeStamp);
    }

    public synchronized void repliedFrame(int id) {
        this.framesWaitingReply.remove(id);
    }

    public void sendFrameAndNoWait(Frame frame) {
        this.peer.sendFrame(frame);
    }

    public synchronized void sendFullFrameAndWaitForAck(FullFrame fullFrame) {
        this.framesWaitingAck.put(fullFrame.getTimestamp(), fullFrame);
        this.peer.sendFrame(fullFrame);
    }

    public synchronized void sendFullFrameAndWaitForRep(FullFrame fullFrame) {
        this.framesWaitingReply.put(fullFrame.getSubclass(), fullFrame);
        this.peer.sendFrame(fullFrame);
    }

    public void writeAudioIn(long timestamp, byte[] data, boolean absolute) {
        if (!this.hold) {
            this.player.write(timestamp, data, absolute);
            if (!this.playing) {
                this.player.play();
                this.playing = true;
            }
        }
    }

    public void startRecorder() {
        this.recorder.record(this);
    }

    private synchronized void retryFramesWaiting() {
        try {
            for (FullFrame retryFullFrame : this.framesWaitingAck.values()) {
                retryFullFrame.incRetryCount();
                if (retryFullFrame.getRetryCount() < 5) {
                    this.peer.sendFrame(retryFullFrame);
                    continue;
                }
                throw new PeerException("Reached retries maximun in the call " + this.srcCallNo + " for a full frame of type " + retryFullFrame.getFrameType() + ", subclass " + retryFullFrame.getSubclass());
            }
            for (FullFrame retryFullFrame : this.framesWaitingReply.values()) {
                retryFullFrame.incRetryCount();
                if (retryFullFrame.getRetryCount() < 5) {
                    this.peer.sendFrame(retryFullFrame);
                    continue;
                }
                throw new PeerException("Reached retries maximun in the call " + this.srcCallNo + " for a full frame of type " + retryFullFrame.getFrameType() + ", subclass " + retryFullFrame.getSubclass());
            }
        }
        catch (PeerException e) {
            this.framesWaitingAck.clear();
            this.framesWaitingReply.clear();
            this.endCall();
            e.printStackTrace();
        }
    }

    public void listen(byte[] buffer, int pos, int length) {
        byte[] audioBuffer = new byte[length];
        System.arraycopy(buffer, pos, audioBuffer, 0, length);
        CallCommandSendFacade.sendVoice(this, audioBuffer);
    }

    public void setDTMFCode(String code) {
        this.dtmfCode = code;
    }

    public String getDTMFCode() {
        return this.dtmfCode;
    }

    public AudioFactory getAudioFactory() {
        return this.audioFactory;
    }

    public void setAudioFactory(AudioFactory audioFactory) {
        this.audioFactory = audioFactory;
    }
}

