/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import org.opengion.fukurou.business.BizLogic_ENTRY;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.util.StringUtil;

/**
 * 回答者IDを暗号化キーを復号化し、アンケートコードに定義されている回答者タグとの整合性をチェックします。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */

public class OP0002S extends BizLogic_ENTRY {

	/**
	 * チェックロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean check() {
		return must( "CDANK,FGKOKAI" );
	}

	/**
	 * メイン処理を定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean logic() {
		boolean isOk = false;

		try {
			String sql = "select A.USERID, A.KTSTAGS from AN01 A "
							+ "where A.CDANK = '{@CDANK}' and A.FGJ = '1'";
			sql( sql );

			set( "KUID", "3".equals( var( "FGKOKAI" ) ) ? new HybsCryptography().decrypt( var( "UID" ) ) : var( "CON.USERID" ) );

			sql = "select A.KTSID, A.KTSTAGS UKTSTAGS from AN05 A "
				+ "where A.USERID = '{@USERID}' and A.KTSID = '{@KUID}' and A.FGJ = '1'";
			sql( sql );

			if( var( "KTSTAGS" ) == null || var ( "KTSTAGS" ).length() == 0 ) {
				if( var( "KTSID" ) != null ) { isOk = true; }
			}
			else {
				String ukstags = "," + var( "UKTSTAGS" ) + ",";
				String[] ktstagArr = StringUtil.csv2Array( var( "KTSTAGS" ) );
				for( String ktstag : ktstagArr ) {
					if( ukstags.indexOf( "," + ktstag + "," ) >= 0 ) {
						isOk = true;
						break;
					}
				}
			}
		}
		catch ( Throwable th ) {}

		if( isOk ) {
			rtn( var( "KUID" ) );
		}
		else {
			error( 2, "ANE0005" );
		}

		return true;
	}
}

