<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<jsp:directive.page import="org.opengion.hayabusa.common.HybsSystem" />
<jsp:directive.page import="org.opengion.hayabusa.resource.UserInfo" />

<og:head headType="init" />

<h1><og:img src="{@SYS.JSP}/customImage/top_head.gif" alt="Iacorner" /></h1>
<div style="position: absolute; top: 10px; right: 10px;">
	<og:link href="{@SYS.JSP}/index.jsp" useGamenId="false" target="_top">
		<img src="{@SYS.JSP}/customImage/top_button_home.png" />
	</og:link>
</div>

<br />

<form action="j_security_check" method="GET">

	<div id="login" align="center">
		<p><og:img src="{@SYS.JSP}/customImage/login_head.gif" alt="ログイン画面" /></p>

		<jsp:scriptlet>
			UserInfo userInfo = (UserInfo)session.getAttribute( HybsSystem.USERINFO_KEY );
			String userID = userInfo.getUserID();

			if( !"GUEST".equals( userID ) ) {
		//		userInfo.clear();
		//		session.removeAttribute( HybsSystem.USERINFO_KEY );

				String backUrl = request.getParameter("BACK_URL");
				if( backUrl == null || backUrl.length() == 0 ) {
					response.sendRedirect(request.getContextPath() + "/jsp/index.jsp");
				}
				else {
					response.sendRedirect(backUrl);
				}
			}
			else {
				userInfo.clear();
				session.removeAttribute( HybsSystem.USERINFO_KEY );
			}
		</jsp:scriptlet>
		
		<table>
			<tr>
				<td><b>ユーザID：</b></td>
				<td><input class="input_login" type="text"  name="j_username" /></td>
			</tr>
			<tr>
				<td><b>パスワード：</b></td>
				<td><input class="input_login" type="password"  name="j_password" /></td>
			</tr>
		</table>
		<p>
			<input type="submit" value="LOGIN" name="j_security_check" />
			&amp;nbsp;
			<input type="reset" value="RESET" />
			<og:hidden name="BACK_URL" value="{@BACK_URL}" />
		</p>
	</div>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
