<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select A.KTSID,A.NMKTS,A.MAILAD,A.KTSTAGS
				,A.FGJ,A.DYSET,A.DYUPD,A.UNIQ,A.USERID
		from AN05 A
		where A.USERID = '{@USER.ID}'
	</jsp:text>
	<og:where startKey="and">
		<og:and value = "A.KTSID		like	'%{@KTSID}%'" />
		<og:and value = "A.NMKTS		like	'%{@NMKTS}%'" />
		<og:and value = "A.MAILAD		like	'%{@MAILAD}%'" />
		<og:and value = "A.KTSTAGS		like	'%{@KTSTAGS}%'" />
		<og:and value = "A.FGJ			=		'{@FGJ}'" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.KTSID,A.UNIQ" />
</og:query>

<og:columnEditor columns="KTSID,NMKTS,MAILAD,KTSTAGS" must="true" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
	<og:submit  value="update"   lbl="COPY"      command="COPY"   accesskey="C"
		keys="noWritable"     vals='"FGJ,DYSET,DYUPD"'/>
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="noWritable"     vals='"KTSID,FGJ,DYSET,DYUPD"' />
	<og:submit  value="update"   lbl="DELETE"    command="DELETE" accesskey="D"
		keys="columnWritable" vals="null" />
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ,USERID"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
