/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import org.opengion.fukurou.business.BizLogic_ENTRY;

/**
 * ユーザー変更 (OP1011) の業務ロジックです。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */

public class OP1011A extends BizLogic_ENTRY {

	/**
	 * チェックロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean check() {
		// ANE0020:メールアドレスが一致していません。
		if( !var( "MAILAD" ).equals( var( "MAILAD2" ) ) ) {
			error( 2, "ANE0020" );
		}

		// ANE0022:メールアドレスが不正です。
		if( var( "MAILAD" ).indexOf( '@' ) < 0 || var( "MAILAD" ).indexOf( '.' ) < 0 ) {
			error( 2, "ANE0022" );
		}

		// ANE0025:画像以外のファイルが指定されています。ファイル名={0}
		if( var( "IMGUSER" ) != null && var( "IMGUSER" ).length() > 0 ) {
			if( !Utils.checkImageName( var( "IMGUSER" ) ) ) {
				error( 2, "ANE0025", var( "IMGUSER" ) );
			}
		}

		return true;
	}

	/**
	 * メイン処理を定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean logic() {
		String sql = "update AN04 set"
			+ " NAME_JA = '{@NAME_JA}'"
			+ ",MAILAD = '{@MAILAD}'"
			+ ",UPROFILE = '{@UPROFILE}'"
			+ ",IMGUSER = case when '{@IMGUSER}' = '' then IMGUSER else '{@IMGUSER}' end"
			+ ",DYUPD = '{@CON.YMDH}'"
			+ ",PGUPD = '{@CON.PGID}'"
			+ ",PGPUPD = '{@CON.PGPID}'"
			+ ",USRUPD = '{@CON.USERID}'"
			+ " where USERID = '{@CON.USERID}'";
		sql( sql );

		return true;
	}
}

