/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import org.opengion.fukurou.business.BizLogic_TABLE;
import org.opengion.fukurou.util.StringUtil;

/**
 * アンケート回答  (OP1003A) の 業務ロジックです。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */
public class OP1003A extends BizLogic_TABLE {

	private int	mcnt	= 1;
	private int suspoint = 0;

	/**
	 * メインカーソルの一番初めで呼ばれるチェックロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	protected boolean fstchk() {
		// 0.2 (2010/09/01) 複数回答禁止機能対応・回答者指定機能対応
		String chk = "select A.FGNODPL, A.FGKOKAI "
			+ "from AN01 A "
			+ "where A.CDANK = [CDANK] "
			+ "and A.FGJ = '1'";
		sql( chk );

		if( "3".equals( var( "FGKOKAI" ) ) ) {
			set( "KUID_TMP", var( "KUID" ) );
		}
		else {
			set( "KUID_TMP", var( "CON.USERID" ) ); 
		}

		if( "1".equals( var( "FGNODPL" ) ) ) {
			// 0.1 (2010/08/01) 登録直前にも回答済みチェックを行う(戻るボタン対策)
			String cnt = "select count(*) CNT from AN11 A "
						+ "where A.USERID = [USERID] and A.CDANK = [CDANK] and A.FGJ = '1'";

			if( "34".indexOf( var( "FGKOKAI" ) ) >= 0 ) {
				cnt += "and A.KUID = '{@KUID_TMP}' ";
			}
			else {
				cnt += "and A.KIPADDR = '{@IPADDRESS}' ";
			}

			sql( cnt );
			if( vari( "CNT" ) > 0 ) {
				error( 2, "ANE0006" );
				return false;
			}
		}

		return true;
	}

	/**
	 * メインカーソルの各行(変更区分の各処理の後)で呼ばれるチェックロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean allchk( final int row ) {
		return true;
	}

	/**
	 * メインカーソルの一番初めで呼ばれるロジックを定義します。
	 * ここでは何も実装されていません。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean first() {
		// 0.1 Oracle、MySQL、HSQLDB対応
//		sql( "select nextval('AN11S01') PGSEQ" );
//		set( "NOKAITO", "K" + StringUtil.intFill( var( "PGSEQ" ), 9 ) );
		String seq = StringUtil.valueOf( seq( "AN11S01" ) );
		set( "NOKAITO", "K" + StringUtil.intFill( seq, 9 ) );

		// [暫定対応] 回答者のローカルIPもグローバルIPと同じ値をセットしています。
		String insAN11 = "insert into AN11("
			+ "NOKAITO,USERID,CDANK,KIPADDR,KLIPADDR,DYKAITO,KUID,SUSPOINT"
			+ ",FGJ,DYSET,PGSET,PGPSET,USRSET,DYUPD,PGUPD,PGPUPD,USRUPD"
			+ ") values ("
			+ "'{@NOKAITO}',[USERID],[CDANK],'{@IPADDRESS}','{@IPADDRESS}','{@CON.YMDH}','{@KUID_TMP}',0"
			+ ",'1','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}'"
			+ ")";

		sql( insAN11 );

		return true;
	}

	/**
	 * メインカーソルの各行(変更区分の各処理の後)で呼ばれるロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean allrow( final int row ) {
		String[] kvalArr = StringUtil.csv2Array( var( "AN_" + line( "CDANK" ) + "_" + line( "CDSITSU" ) ) );
		for( String kval : kvalArr ) {
			if( kval == null || kval.length() == 0 ) { continue; }

			set( "KVAL", kval );
			set( "KNAME", null );
			set( "IMGKVAL", null );
			set( "FGOTHER", "0" );

			set( "KVAL_TMP", null );

			// その他で、自由入力された回答の処理
			String sql = "select count(*) CNT from AN03"
				+ " where USERID = [USERID]"
				+ " and CDANK = [CDANK]"
				+ " and CDSITSU = [CDSITSU]"
				+ " and FGJ = '1'";
			sql( sql );

			sql = "select KVAL KVAL_TMP,KNAME,IMGKVAL,FGCORRECT from AN03"
				+ " where USERID = [USERID]"
				+ " and CDANK = [CDANK]"
				+ " and CDSITSU = [CDSITSU]"
				+ " and KVAL = '{@KVAL}'"
				+ " and FGJ = '1'";
			sql( sql );

			// 選択項目で定義されている質問 かつ 回答内容の値が選択項目として定義されていない場合は、その他とみなす
			if( vari( "CNT" ) > 0 && ( var( "KVAL_TMP" ) == null || var( "KVAL_TMP" ).length() == 0 ) ) {
				set( "FGOTHER", "1" );
			}

			set( "SUPOINT", "1".equals( var( "FGCORRECT" ) ) ? linei( "SUPOINT" ) : 0 );
			suspoint += vari( "SUPOINT" );

			set( "NOMEISAI", mcnt );
			String insAN12 = "insert into AN12("
				+ "NOKAITO,NOMEISAI,USERID,CDANK,CDSITSU,KVAL,KNAME,FGOTHER,SUPOINT,FGCORRECT"
				+ ",FGJ,DYSET,PGSET,PGPSET,USRSET,DYUPD,PGUPD,PGPUPD,USRUPD"
				+ ") values ("
				+ "'{@NOKAITO}','{@NOMEISAI}',[USERID],[CDANK],[CDSITSU],'{@KVAL}','{@KNAME}','{@FGOTHER}',{@SUPOINT},'{@FGCORRECT}'"
				+ ",'1','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}'"
				+ ")";
			sql( insAN12 );
			mcnt++;
		}

		return true;
	}

	/**
	 * メインカーソルの一番最後で呼ばれるロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean last() {
		if( suspoint > 0 ) {
			set( "SUSPOINT", suspoint );
			String sql = "update AN11 set SUSPOINT = {@SUSPOINT} where NOKAITO = '{@NOKAITO}'";
			sql( sql );
		}
		rtn( var( "NOKAITO" ) );
		return true;
	}
}
