/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;

public final class HybsSystem {
    public static final int BUFFER_SMALL = 50;
    public static final int BUFFER_MIDDLE = 200;
    public static final int BUFFER_LARGE = 500;
    public static final String CR;
    public static final String BR;
    public static final char FS;
    private static Map<String, String> sysParam;
    private static Map<String, String> reqCache;
    private static String realPath;
    private static boolean paramSetFlag;
    public static final String ROW_SEL_KEY = "h_rowSel";
    public static final String ROW_ID_KEY = "cb";
    public static final String TBL_MDL_KEY = "h_tblmdl";
    public static final String TBL_MDL_CONKEY = "h_tblmdlCon";
    public static final String VIEWFORM_KEY = "h_vform";
    public static final String VIEWLINK_KEY = "h_vlink";
    public static final String VIEW_MARK_KEY = "h_vmark";
    public static final String EDIT_MARK_KEY = "h_emark";
    public static final String USERINFO_KEY = "h_uInfo";
    public static final String GUIINFO_KEY = "h_gInfo";
    public static final String REQ_CACHE_KEY = "h_req";
    public static final String ERR_MSG_KEY = "h_errMsg";
    public static final String ST_BAR_OBJ_KEY = "h_stBar";
    public static final String SCEDULE_KEY = "h_timer";
    public static final String SCEDULE_TASK_KEY = "h_timer_task";
    public static final String FORWARD_PAGE_KEY = "h_fpg";
    public static final String REVIEW_PAGE_KEY = "h_rpg";
    public static final String BACK_GAMENID_KEY = "h_bgid";
    public static final String BACK_ADDRESS_KEY = "h_bgadrs";
    public static final String BACK_ROW_KEY = "h_brow";
    public static final String SHELL_KEEP_KEY = "h_shKeepKey";
    public static final String OLD_USERID_KEY = "h_oldID";
    public static final String SORT_COLUMNS = "h_sortClmns";
    public static final String SORT_ASCENDING = "h_sortAsc";
    public static final String JOINT_STRING = "__";
    private static final Object lock;
    public static final String CONSISTENCY_KEY = "h_consisKey";
    public static final String NO_XFER_KEY = "hX_";
    public static final String MULTI_SESSION_CHECK = "MSC";
    public static final String JF_CHART_CACHE_KEY = "h_chartKey";
    public static final int MAX_GET_LENGTH = 2083;
    public static final char GUI_DELIMITER = '|';
    public static final String LOCAL_RES_KEY = "h_lclRes";
    public static final String LOCAL_CONTX_ERR_KEY = "h_lclConErr";
    public static final String GUI_GR_MENU_CACHE_KEY = "h_grpCache";
    public static final String GUI_FAV_MENU_KEY = "GUI_FAV_MENU_KEY";
    public static final String TBL_WRITER_CLMS = "TBL_WRITER_CLMS";
    public static final String MUST_KEY = "h_must_";
    public static final String DB_LAST_SQL_KEY = "h_lastSql";
    public static final String NO_TRANSITION_MODE_KEY = "h_noTrnsKey";
    public static final String USE_EVENT_COLUMN_KEY = "h_eventColumn";
    public static final String EVENT_COLUMN_CLASS = "h_evElm";
    public static final String EVENT_COLUMN_WRITABLE = "h_evWrtbl";
    public static final String EVENT_COLUMN_ID = "h_evCid";
    public static final String EVENT_COLUMN_INITVAL = "h_evVal";
    public static final String URL_CHECK_KEY = "h_urlCheck";
    public static final String USE_AJAX_SUBMIT_KEY = "h_ajaxSubmit";
    public static final String VIEW_SORT_KEY = "h_viewSrt";
    public static final String USER_VIEW_CLMS = "H_USRVWCLMS_";
    public static final String TRANSACTION_KEY = "h_tran";
    public static final String REPORT_ENCODE = "UTF-8";
    public static final String HOST_NAME;
    public static final String HOST_ADRS;

    private HybsSystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInitialData(Map<String, String> map) {
        Object object = lock;
        synchronized (object) {
            sysParam = map;
            realPath = map.get("REAL_PATH");
            if (paramSetFlag) {
                sysParam.putAll(reqCache);
            }
        }
        System.out.println("    [" + sysParam.get("CONTEXT_NAME") + "] \u306e\u30b7\u30b9\u30c6\u30e0\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u3001[" + sysParam.size() + "] \u4ef6\u8a2d\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getParam(String string) {
        Object object = lock;
        synchronized (object) {
            return sysParam.get(string);
        }
    }

    public static boolean isParamSet() {
        return paramSetFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRequestParam(String string, String string2, int n, String string3) {
        Object object = lock;
        synchronized (object) {
            sysParam.put("SERVER_NAME", string);
            String string4 = n == 80 ? "" : ":" + n;
            String string5 = string2 + "://" + string + string4;
            sysParam.put("SERVER_URL", string5 + "/");
            String string6 = string5 + string3 + "/";
            sysParam.put("CONTEXT_URL", string6);
            reqCache.put("SERVER_NAME", string);
            reqCache.put("SERVER_URL", string5 + "/");
            reqCache.put("CONTEXT_URL", string6);
            paramSetFlag = true;
        }
    }

    public static String getDate() {
        return HybsSystem.getDate(HybsSystem.getParam("SYS_TIME"));
    }

    public static String getDate(long l) {
        String string = HybsSystem.getParam("SYS_TIME");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.JAPAN);
        return simpleDateFormat.format(new Date(l));
    }

    public static String getDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.JAPAN);
        return simpleDateFormat.format(new Date());
    }

    public static String getDate(long l, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.JAPAN);
        return simpleDateFormat.format(new Date(l));
    }

    public static String getYMDate(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.add(2, n);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM", Locale.JAPAN);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String sys(String string) throws HybsSystemException {
        if (string == null) {
            String string2 = "\u30ad\u30fc\u304c null \u3067\u3059\u3002";
            throw new HybsSystemException(string2);
        }
        if ("DATE".equals(string)) {
            return HybsSystem.getDate();
        }
        String string3 = HybsSystem.getParam(string);
        if (string3 == null && !string.startsWith("h_")) {
            String string4 = CR + "\u30b7\u30b9\u30c6\u30e0\u30ea\u30bd\u30fc\u30b9\u30ad\u30fc\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002key = " + string;
            LogWriter.log((String)string4);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HybsEntry[] sysEntry(String string) {
        ArrayList<HybsEntry> arrayList = new ArrayList<HybsEntry>();
        Object[] objectArray = lock;
        synchronized (lock) {
            for (String string2 : sysParam.keySet()) {
                if (string2 == null || !string2.startsWith(string)) continue;
                HybsEntry hybsEntry = new HybsEntry(string2, sysParam.get(string2));
                arrayList.add(hybsEntry);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            objectArray = arrayList.toArray(new HybsEntry[arrayList.size()]);
            Arrays.sort(objectArray);
            return objectArray;
        }
    }

    public static int sysInt(String string) {
        int n;
        if (string == null) {
            String string2 = "\u30ad\u30fc\u304c null \u3067\u3059\u3002";
            throw new HybsSystemException(string2);
        }
        String string3 = HybsSystem.getParam(string);
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            String string4 = "\u30b7\u30b9\u30c6\u30e0\u30ea\u30bd\u30fc\u30b9 \u306e\u5024\u304c\u6570\u5b57\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" + CR + "  Resource key=[" + string + "] val=[" + string3 + "]";
            throw new HybsSystemException(string4, numberFormatException);
        }
        return n;
    }

    public static boolean sysBool(String string) {
        return Boolean.valueOf(HybsSystem.sys(string));
    }

    public static String url2dir(String string) {
        return StringUtil.urlAppend((String)realPath, (String)string).replace('/', FS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[][] getSystemResourceData() {
        String[][] stringArray;
        Object object = lock;
        synchronized (object) {
            Set<Map.Entry<String, String>> set = sysParam.entrySet();
            int n = set.size();
            stringArray = new String[2][n];
            Iterator<Map.Entry<String, String>> iterator = set.iterator();
            for (int i = 0; i < n; ++i) {
                Map.Entry<String, String> entry = iterator.next();
                stringArray[0][i] = entry.getKey();
                stringArray[1][i] = entry.getValue();
            }
        }
        return stringArray;
    }

    public static String getContextName() {
        return HybsSystem.sys("CONTEXT_NAME");
    }

    public static Calendar getCalendar(String string) {
        if (string == null || string.length() != 8 && string.length() != 14) {
            String string2 = "\u5f15\u6570\u306f\u3001YYYYMMDD \u307e\u305f\u306f YYYYMMDDHHMMSS \u5f62\u5f0f\u306e\u65e5\u4ed8\u3051\u6587\u5b57\u5217\u306e\u307f\u3067\u3059\u3002 value=[" + string + "]";
            throw new HybsSystemException(string2);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = Integer.parseInt(string.substring(0, 4));
        int n5 = Integer.parseInt(string.substring(4, 6)) - 1;
        int n6 = Integer.parseInt(string.substring(6, 8));
        if (string.length() == 14) {
            n = Integer.parseInt(string.substring(8, 10));
            n2 = Integer.parseInt(string.substring(10, 12));
            n3 = Integer.parseInt(string.substring(12, 14));
        }
        calendar.set(n4, n5, n6, n, n2, n3);
        return calendar;
    }

    public static String getDate(String string, int n) {
        if (string == null || string.length() != 8) {
            String string2 = "\u5f15\u6570 baseDate \u306f\u3001YYYYMMDD \u5f62\u5f0f\u306e\u65e5\u4ed8\u3051\u6587\u5b57\u5217\u306e\u307f\u3067\u3059\u3002 baseDate=[" + string + "]";
            throw new HybsSystemException(string2);
        }
        Calendar calendar = HybsSystem.getCalendar(string);
        calendar.add(5, n);
        String string3 = null;
        int n2 = calendar.get(1);
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(5);
        string3 = String.valueOf(n2);
        string3 = n3 < 10 ? string3 + "0" + n3 : string3 + n3;
        string3 = n4 < 10 ? string3 + "0" + n4 : string3 + n4;
        return string3;
    }

    public static Object newInstance(String string) {
        try {
            return Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = "\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002class=[" + string + "]" + CR + classNotFoundException.getMessage();
            throw new RuntimeException(string2, classNotFoundException);
        }
        catch (LinkageError linkageError) {
            String string3 = "\u30ea\u30f3\u30b1\u30fc\u30b8\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002class=[" + string + "]" + CR + linkageError.getMessage();
            throw new RuntimeException(string3, linkageError);
        }
        catch (InstantiationException instantiationException) {
            String string4 = "\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u751f\u6210\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002class=[" + string + "]" + CR + instantiationException.getMessage();
            throw new RuntimeException(string4, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string5 = "\u30af\u30e9\u30b9\u307e\u305f\u306f\u521d\u671f\u5316\u5b50\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093\u3002class=[" + string + "]" + CR + illegalAccessException.getMessage();
            throw new RuntimeException(string5, illegalAccessException);
        }
        catch (RuntimeException runtimeException) {
            String string6 = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc class=[" + string + "]" + CR + runtimeException.getMessage();
            throw new RuntimeException(string6, runtimeException);
        }
    }

    static {
        String string;
        String string2;
        CR = System.getProperty("line.separator");
        BR = "<br />" + CR;
        FS = System.getProperty("file.separator").charAt(0);
        sysParam = null;
        reqCache = new HashMap<String, String>();
        realPath = null;
        paramSetFlag = false;
        lock = new Object();
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string2 = "Unknown";
            string = "Unknown";
        }
        HOST_NAME = string2;
        HOST_ADRS = string;
    }
}

