/*
 * html2hdml
 *
 * Coprygight (C) 2000-2003 Dino Co.,Ltd.
 * http://www.dino.co.jp/
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "html2hdml.h"
#include "strinput.h"

int add_header_and_footer(void);
int convert_A(char *stago, char *elemname, char **attr, char *tagc);
int convert_A_(char *stago, char *elemname, char **attr, char *tagc);
int convert_IMG(char *stago, char *elemname, char **attr, char *tagc);
int convert_INPUT(char *stago, char *elemname, char **attr, char *tagc);
int convert_SELECT(char *stago, char *elemname, char **attr, char *tagc);
int convert_OPTION(char *stago, char *elemname, char **attr, char *tagc);

int convert_FORM(char *stago, char *elemname, char **attr, char *tagc);
int convert_FORM_(char *stago, char *elemname, char **attr, char *tagc);

int convert_TEXTAREA(char *stago, char *elemname, char **attr, char *tagc);
int convert_TEXTAREA_(char *stago, char *elemname, char **attr, char *tagc);
int convert_PRE(char *stago, char *elemname, char **attr, char *tagc);
int convert_PRE_(char *stago, char *elemname, char **attr, char *tagc);
int convert_CENTER(char *stago, char *elemname, char **attr, char *tagc);
int convert_CENTER_(char *stago, char *elemname, char **attr, char *tagc);

int convert_BASE(char *stago, char *elemname, char **attr, char *tagc);
char *base_url(char *href);

char *replace_docomochar(char *str);

int convert_text(char *text);
int convert_ret(void);
int convert_comment(char *text);


char *remove_quote(unsigned char *str);
char *url_encode(unsigned char *str);

int add_text_card(void);
int add_cb_card(void); /* check box */
int add_rb_card(void); /* radio button */
int add_reset_card(int formnum);

int gl_cardnum;
int gl_formnum;
int gl_text_card;
int gl_cb_card;
int gl_rb_card;
int gl_reset_card;

char *gl_form_dest = NULL;
char *gl_form_method = NULL;
char *gl_select_init = NULL;

char *gl_select_1st_var = NULL;
char *gl_select_selected_var = NULL;
int gl_already_selected = 0;

int gl_printed_last_a = 0;
int gl_beginning_of_line = 1;

int gl_in_pre = 0;

int gl_align = 0;
int gl_last_align = 0;
#define ALIGN_LEFT   0
#define ALIGN_CENTER 1
#define ALIGN_RIGHT  2

char *gl_base_abs = NULL;
char *gl_base_rel = NULL;

int init_cardnum(void)
{
    gl_cardnum = 0;
    gl_formnum = 0;
    gl_text_card = 0;
    gl_cb_card = 0;
    gl_rb_card = 0;
    gl_reset_card = 0;

    return 0;
}

/* MUST REFINE */
char *url_double_encode(unsigned char *str)
{
    unsigned char *p1, *p2;
    unsigned char *ret;

    ret = my_malloc(sizeof(char)*(strlen(str)*5+1));

    p1 = str;
    p2 = ret;

    while (*p1 != '\0') {
	if ((*p1 >= 0x81 && *p1 <= 0xff)) {
	    sprintf(p2, "%%25%02X", (int)*p1);
	    p1++;
	    p2 += 5;
	} else if (*p1 == ' ') {
	    *p2 = '+';
	    p1++;
	    p2++;
	} else {
	    *p2 = *p1;
	    p1++;
	    p2++;
	}
    }
    *p2 = *p1;

    return ret;
}

/* MUST REFINE */
char *url_encode(unsigned char *str)
{
    unsigned char *p1, *p2;
    unsigned char *ret;

    ret = my_malloc(sizeof(char)*(strlen(str)*3+1));

    p1 = str;
    p2 = ret;

    while (*p1 != '\0') {
	if ((*p1 >= 0x81 && *p1 <= 0xff)) {
	    sprintf(p2, "%%%02X", (int)*p1);
	    p1++;
	    p2 += 3;
	} else if (*p1 == ' ') {
	    *p2 = '+';
	    p1++;
	    p2++;
	} else {
	    *p2 = *p1;
	    p1++;
	    p2++;
	}
    }
    *p2 = *p1;

    return ret;
}


/* return quoting char: [\0\'\"] */
char *remove_quote(unsigned char *str)
{
    unsigned char print_buf[BUFFER_SIZE];
    unsigned char qc = '\0';
    unsigned char *p;

    if (str == NULL) return NULL;

    p = print_buf;

    if (*str == '"' || *str == '\'') {
	qc = *str;
	str++;
    }

    while (*str) {
	if (*str == '"' || *str == '\'') {
	    if (*str == qc && *(str+1) == '\0') {
		break;
	    }
	    sprintf(p, "%%%02X", (int)*str);
	} else {
	    *p = *str;
	    p++; 
	}
	str++;
    }
    *p = '\0';

    return my_strdup(print_buf);
}

int add_header_and_footer(void)
{
    add_piece(enum_begin, 
	      "<HDML version=3.0 markable=TRUE TTL=0>\n");

    if (gl_cardnum) {
	if ((gl_reset_card == 1) && (gl_formnum == 1)) {
	    add_piece(enum_begin,
		      "<NODISPLAY>\n"
		      "<ACTION TYPE='ACCEPT' TASK='GOSUB' FRIEND='TRUE'"
		      " DEST='#r1' NEXT='#0'>\n"
		      "</NODISPLAY>\n");
	} else {
	    add_piece(enum_begin,
		      "<NODISPLAY>\n"
		      "<ACTION TYPE='ACCEPT' TASK='GOSUB' FRIEND='TRUE'"
		      " DEST='#i' NEXT='#0'>\n"
		      "</NODISPLAY>\n");

	    add_piece(enum_header,
		      "<NODISPLAY NAME='i'>\n"
		      "<ACTION TYPE='ACCEPT' TASK='RETURN' VARS='");
	    append_varlist(enum_header, enum_init, 1);
	    add_piece(enum_header, 
		      "'>\n"
		      "</NODISPLAY>\n");
	}
    }

    /* MARKABLE="TRUE" ??? */
    if (gl_cardnum) {
	add_piece(enum_header, "<DISPLAY NAME=0");
    } else {
	add_piece(enum_header, "<DISPLAY");
    }
    if (is_varlist_empty(enum_title)) {
	add_piece(enum_header, ">\n");
    } else {
	add_piece(enum_header, " TITLE='");
	append_varlist(enum_header, enum_title, 0);
	add_piece(enum_header, "'>\n");
    }

    add_piece(enum_body,
	      "</DISPLAY>\n");
    add_piece(enum_footer, 
	      "</HDML>\n");

    return 0;
}

/* MUST REFINE */
char *replace_docomochar(char *str)
{
    unsigned char *p;

    p = str;
    while (*p != '\0') {
	if (*p == 0xf8 || *p == 0xf9) {
	    /* docomo picture */
	    *p = ' ';
	    p++;
	    if (*p >= 0x40 && *p <= 0xfc) {
		*p = ' ';
		p++;
	    }
	} else if ((*p >= 0x81 && *p <= 0x9f) ||
		   (*p >= 0xe0 && *p <= 0xfc)) {
	    /* sjis 1st byte */
	    p++;
	    if (*p >= 0x40 && *p <= 0xfc) {
		/* sjis 2nd byte */
		p++;
	    }
	} else {
	    p++;
	}
    }

    return str;
}


int block_boundary(void)
{
  if (gl_beginning_of_line == 0) {
    /* last line isn't ended. insert <br>. */

    if (gl_align) {
      add_piece(enum_body, "<br>\n");
    } else {
      add_piece(enum_body, "<br>");
    }
    gl_beginning_of_line = 1;
  }
  return 0;
}

int alignment(void)
{
  if (gl_beginning_of_line && is_current_output(enum_body)) {
    if (gl_align == ALIGN_CENTER) {
      add_piece(enum_body, "<center>");
    } else if (gl_align == ALIGN_RIGHT) {
      add_piece(enum_body, "<right>");
    }
  }
  gl_beginning_of_line = 0;
  return 0;
}


int convert_text(char *text)
{
    char *p = NULL, *enc_p = NULL;
    /* p = replace_docomochar(text); */
    p = text;

    alignment();

    if (is_current_output(enum_select)) {
	enc_p = url_encode(p);
	add_piece(enum_select, enc_p);
	add_piece(enum_footer, p);
	my_free(enc_p);
    } else {
      add_piece(enum_current, p);
      if (!is_current_output(enum_title)) {
	gl_beginning_of_line = 0;
      }
    }
    my_free(p);
    return 0;
}
int convert_ret(void)
{
    if (is_current_output(enum_select)) {
	add_piece(enum_footer, "\n");
    } else if (is_current_output(enum_title) ||
	       is_current_output(enum_textarea)) {
	/* no output */
	;
    } else if (gl_align) {
	/* center of right */
	add_piece(enum_current, " ");
    } else if (gl_in_pre && is_current_output(enum_body)) {
	alignment();

	add_piece(enum_current, "<br>\n");
	gl_beginning_of_line = 1;
    } else {
	add_piece(enum_current, "\n");
    }
    return 0;
}

int convert_spc(char *spc)
{
    if (is_current_output(enum_select)) {
	add_piece(enum_select, spc);
	add_piece(enum_footer, spc);
    } else if (gl_in_pre) {
	char *buf, *p, *p1;
	int i = 0;

	alignment();

	buf = my_malloc(sizeof(char)*(strlen(spc)*6*8+1));
	p = buf;
	p1 = spc;
	while (*p1) {
	    if (*p1 == ' ') {
		i++;
		sprintf(p, "&nbsp;");
		p += 6;
	    } else if (*p1 == '\t') {
		sprintf(p, "%.*s", (8 - (i % 8))*6 ,
			"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
		p += (8 - (i % 8))*6;
	    }
	    p1++;
	}
	add_piece(enum_current, buf);
    } else {
	add_piece(enum_current, spc);
    }
    return 0;
}
int convert_comment(char *text)
{
    return 0;
}

int convert_BR(char *stago, char *elemname, char **attr, char *tagc)
{
  if (gl_align) {
    /* center or right */
    add_piece(enum_body, "<br>\n");
  } else {
    add_piece(enum_body, "<br>");
  }
  gl_beginning_of_line = 1;

  return 0;
}

int convert_HR(char *stago, char *elemname, char **attr, char *tagc)
{
  block_boundary();

  add_piece(enum_body, "--------------<br>");

  return 0;
}

int convert_P(char *stago, char *elemname, char **attr, char *tagc)
{
  char *align = NULL;

  block_boundary();

  align = remove_quote(attr[(int)enum_ALIGN]); /* ALIGN */
  if (align) {
    if (strcmpi(align, "center") == 0) {
      gl_last_align = gl_align;
      gl_align = ALIGN_CENTER;
    } else if (strcmpi(align, "right") == 0) {
      gl_last_align = gl_align;
      gl_align = ALIGN_RIGHT;
    } else {
      /* illegal :> */
      gl_last_align = gl_align;
      gl_align = ALIGN_LEFT;
    }
    my_free(align);
  } else {
    /* no attribute "align" : keep current state */
    gl_last_align = gl_align;
  }

  return 0;
}

int convert_P_(char *stago, char *elemname, char **attr, char *tagc)
{
  block_boundary();

  add_piece(enum_current, "<br>\n");
  gl_align = gl_last_align;
  gl_last_align = ALIGN_LEFT;
  return 0;
}

int convert_A(char *stago, char *elemname, char **attr, char *tagc)
{
    char *href = NULL, *enc_href = NULL, *akey = NULL, *base = NULL;
    char *p;
    /* char qc; */ /* quoting character: [\0\'\"] */
    char print_buf[BUFFER_SIZE];

    alignment();

    akey = remove_quote(attr[(int)enum_ACCESSKEY]); /* HREF */
    if (akey && !(isdigit(*akey))) {
	my_free(akey);
	akey = NULL;
    }

    href = remove_quote(attr[(int)enum_HREF]); /* HREF */
    if (href == NULL) return 0; /* no HREF attribute. ignore. */
    if (*href == '#') {
	my_free(href);
	return 0; /* link to same page. ignore. */
    }

    p = strchr(href, '#');
    if (p) {
	/* link to another page. */
	/* ignore #label in URL */
	*p = '\0';
    } else {
	/* searching last char of URL */
	p = strchr(href, '\0');
    }

    if (gl_convertopt.a_href_html2hdml == 1) {
	/* now p points last char excluding quotation one */
	if ((strlen(href) >= 5) && strncmp(p-5, ".html", 5) == 0) {
	    strncpy(p-5, ".hdml", 5);
	} else if ((strlen(href) >= 4) && strncmp(p-4, ".htm", 4) == 0) {
	    strncpy(p-4, ".hdm", 4);
	}
    }

    if (href) {
	enc_href = url_encode(href);
	/* if (qc) value--; */
	/* my_free(value) */
    }


    if (strncmpi(enc_href, "mailto:", 7) == 0) {
	char *p, *p2;
	char *to = NULL, *subj = NULL, *mt = NULL;
	int size;
	p = strchr(enc_href + 7, '?');
	if (p == NULL) {
	    /* no "?" */
	    to = my_strdup(enc_href+7);
	} else {
	    /* p points "?" */
	    if (p == enc_href + 7) {
		/* no mail address specified */
	    } else {
		size = p - (enc_href+7);
		to = my_malloc(sizeof(char)*(size+1));
		strncpy(to, enc_href+7, size);
		to[size] = '\0';
	    }
	    p++;
	    while (*p) {
		if (strncmpi(p, "subject=", 8) == 0) {
		    p2 = strchr(p, '&');
		    if (p2 == NULL) p2 = strchr(p, '\0');
		    size = p2 - (p+8);
		    subj = my_malloc(sizeof(char)*(size+1));
		    strncpy(subj, p+8, size);
		    subj[size] = '\0';
		} else if (strncmpi(p, "body=", 5) == 0) {
		    p2 = strchr(p, '&');
		    if (p2 == NULL) p2 = strchr(p, '\0');
		    size = p2 - (p+5);
		    mt = my_malloc(sizeof(char)*(size+1));
		    strncpy(mt, p+5, size);
		    mt[size] = '\0';
		} else {
		    p2 = strchr(p, '&');
		    if (p2 == NULL) p2 = strchr(p, '\0');
		}
		if (*p2 == '&') p2++;
		p = p2;
	    }
	}

	sprintf(print_buf,
		"<a task='gosub'"
		" dest='device:home/goto?svc=Email&SUB=sendMsg'"
		" vars='");
	p = strchr(print_buf, '\0');
	if (to) {
	    sprintf(p, "TO=%s&", to);
	    my_free(to);
	    p = strchr(print_buf, '\0');
	}
	if (subj) {
	    sprintf(p, "SUBJ=%s&", subj);
	    my_free(subj);
	    p = strchr(print_buf, '\0');
	}
	if (mt) {
	    sprintf(p, "MT=%s&", mt);
	    my_free(mt);
	    p = strchr(print_buf, '\0');
	}
	if (*(p-1) == '&') p--;
	sprintf(p, "'>");
		
/*
		"<action type='soft1' task='gosub'"
		" dest='device:home/goto?svc=Email&SUB=sendMsg'"
		" vars='TO=%s&SUBJ=inquire'label='send mail'>",

mailto:090@docomo.ne.jp?subject=Yahoo!mobile&body=http://mobile.yahoo.co.jp
mailto:?subject=DAIMEI&body=NAIYO

<ACTION TYPE=ACCEPT TASK=GOSUB
    DEST="device:home/goto?svc=Email&SUB=sendMsg"
    VARS=SUBJ=DAIMEI&MT=NAIYO
    LABEL="send mail" >
TO
SUBJ
MT

*/

    } else if (strncmpi(href, "tel:", 4) == 0) {
	sprintf(print_buf, 
/*
		"<action type='soft1' task='call' number='%s'>",
*/
		"<a task='call' number='%s'>",
		href+4);
    } else {
      /* normal link: <a task=gosub dest=''> */
	base = base_url(enc_href);
	if (base == NULL) base = "";

	if (akey) {
	    sprintf(print_buf,
		    "%s%s task=gosub accesskey='%c' dest='%s%s'%s",
		    stago, elemname, *akey, base, enc_href, tagc);
	} else {
	    sprintf(print_buf,
		    "%s%s task=gosub dest='%s%s'%s",
		    stago, elemname, base, enc_href, tagc);
	}
    }
    gl_printed_last_a = 1;

    add_piece(enum_body, print_buf);

    my_free(href); my_free(enc_href); my_free(akey);

    return 0;
}

int convert_A_(char *stago, char *elemname, char **attr, char *tagc)
{
    char print_buf[BUFFER_SIZE];

    alignment();

    if (gl_printed_last_a == 1) {
	sprintf(print_buf, "%s%s%s", stago, elemname, tagc); /*</a>*/
	add_piece(enum_body, print_buf);
    } else if (gl_printed_last_a == 2) {
	sprintf(print_buf, "%saction%s", stago, tagc); /*</action>*/
	add_piece(enum_body, print_buf);
    }
    gl_printed_last_a = 0;

    return 0;
}

int convert_IMG(char *stago, char *elemname, char **attr, char *tagc)
{
    char print_buf[BUFFER_SIZE];
    char *src, *alt, *base;
    char *p;

    alignment();

    src = remove_quote(attr[(int)enum_SRC]); /* SRC */
    alt = remove_quote(attr[(int)enum_ALT]); /* ALT */

    if (src) {
	if (gl_convertopt.img_src_gif2bmp == 1) {
	    p = strchr(src, '\0');
	    /* now p points last char excluding quotation one */
	    if ((strlen(src) >= 3) && strncmp(p-3, ".gif", 3) == 0) {
		strncpy(p-3, ".bmp", 3);
	    }
	}

	base = base_url(src);
	if (base == NULL) base = "";

	if (gl_convertopt.img_alt == 1) {
	    if (alt) {
		sprintf(print_buf,
			"[%s]", alt);
	    }
	} else {
	    if (alt) {
		sprintf(print_buf,
			"%s%s src='%s%s' alt='%s'%s",
			stago, elemname, base, src, alt, tagc);
	    } else {
		sprintf(print_buf,
			"%s%s src='%s%s'%s",
			stago, elemname, base, src, tagc);
	    }
	}

	if (gl_convertopt.img == 1) {
	    add_piece(enum_body, print_buf);
	}
    }

    return 0;
}


int convert_FORM(char *stago, char *elemname, char **attr, char *tagc)
{
    char *p1, *p2, *p3;
    gl_formnum++;

    reset_varlist(enum_reset);
    reset_varlist(enum_submit);

    /* discard infomation of previous form */
    my_free(gl_form_dest);
    my_free(gl_form_method);
    gl_form_dest = gl_form_method = NULL;

    /* must refine... */
    p1 = remove_quote(attr[(int)enum_ACTION]);
    if (p1 == NULL) {
      /* gl_form_dest = NULL; */
    } else {
	p2 = base_url(p1);
	if (p2) {
	    p3 = my_malloc((strlen(p2)+strlen(p1)+1)*sizeof(char));
	    sprintf(p3, "%s%s", p2, p1);
	    my_free(p1); my_free(p2);
	    gl_form_dest = p3;
	} else {
	    gl_form_dest = p1;
	}
    }

    gl_form_method = remove_quote(attr[(int)enum_METHOD]);
    if (!gl_form_method) {
	gl_form_method = my_strdup("get");
    }
    
    return 0;
}

int convert_FORM_(char *stago, char *elemname, char **attr, char *tagc)
{
    my_free(gl_form_dest);
    my_free(gl_form_method);
    gl_form_dest = gl_form_method = NULL;

    reset_varlist(enum_reset);
    reset_varlist(enum_submit);
    return 0;
}

int convert_TEXTAREA(char *stago, char *elemname, char **attr, char *tagc)
{
    char print_str[BUFFER_SIZE];
    char *name;

    alignment();

    name    = remove_quote(attr[(int)enum_NAME]); /* NAME */

    gl_cardnum++;

    /*****************/
    /*** print tag ***/
    /*****************/

    sprintf(print_str,
	    "<A TASK=GOSUB DEST='#t' RECEIVE='v%d'>$v%d</A>",
	    gl_cardnum, gl_cardnum);
    add_piece_with_sp_char(enum_body, print_str);

    /******************/
    /*** print card ***/
    /******************/

    add_text_card();    

    /*********************************/
    /*** add init & reset variable ***/
    /*********************************/

    reset_varlist(enum_textarea);

    sprintf(print_str, "$v%d=", gl_cardnum);
    add_piece_with_sp_char(enum_textarea, print_str);

    /***************************/
    /*** add submit variable ***/
    /***************************/

    if (name) {
	sprintf(print_str, "%s=$v%d&", name, gl_cardnum);
	add_piece_with_sp_char(enum_submit, print_str);
    }
    
    return 0;
}

int convert_TEXTAREA_(char *stago, char *elemname, char **attr, char *tagc)
{
    catdup_varlist(enum_init, enum_textarea);
    catdup_varlist(enum_reset, enum_textarea);

    reset_varlist(enum_textarea);

    add_piece(enum_init, "&");
    add_piece(enum_reset, "&");

    return 0;
}

int convert_PRE(char *stago, char *elemname, char **attr, char *tagc)
{
  block_boundary();

  gl_in_pre = 1;
  return 0;
}

int convert_PRE_(char *stago, char *elemname, char **attr, char *tagc)
{
  block_boundary();

  gl_in_pre = 0;
  return 0;
}

int convert_CENTER(char *stago, char *elemname, char **attr, char *tagc)
{
  block_boundary();

  gl_last_align = gl_align;
  gl_align = ALIGN_CENTER;
  return 0;
}

int convert_CENTER_(char *stago, char *elemname, char **attr, char *tagc)
{
  block_boundary();

  gl_align = gl_last_align;
  gl_last_align = ALIGN_LEFT;

  return 0;
}

int convert_INPUT(char *stago, char *elemname, char **attr, char *tagc)
{
/*    char *str;*/
    char *p;
    char *name, *value, *enc_value = NULL;
    char *checked;
    /* char qc; */ /* quoting character: [\0\'\"] */
/*    int len = 0;*/
    char print_str[BUFFER_SIZE];
    enum inputtype type;
    int radio_cardnum = -1; /* -1: error state */

    alignment();

    strcpy(print_str, "");

    gl_cardnum++;

    p = attr[(int)enum_TYPE]; /* TYPE */
    if (p) {
	p = remove_quote(p);
    }

    if ((p == NULL) || strcmpi(p, "text") == 0) {
	type = enum_TEXT;
    } else if (strcmpi(p, "password") == 0) {
	type = enum_PASSWORD;
    } else if (strcmpi(p, "checkbox") == 0) {
	type = enum_CHECKBOX;
    } else if (strcmpi(p, "radio") == 0) {
	type = enum_RADIO;
    } else if (strcmpi(p, "hidden") == 0) {
	type = enum_HIDDEN;
    } else if (strcmpi(p, "submit") == 0 || strcmpi(p, "image") == 0) {
	type = enum_SUBMIT;
    } else if (strcmpi(p, "reset") == 0) {
	type = enum_RESET;
    } else {
/*	type = enum_UNKNOWNTYPE;*/
	type = enum_TEXT;
    }
    free (p);

    value   = remove_quote(attr[(int)enum_VALUE]); /* VALUE */
    name    = remove_quote(attr[(int)enum_NAME]); /* NAME */
    checked = remove_quote(attr[(int)enum_CHECKED]); /* CHECKED */

    /*************************/
    /*** set default value ***/
    /*************************/
    switch (type) {
      case enum_RADIO:
	radio_cardnum = find_radionum(name);
	if (radio_cardnum == -1) {
	    /* name == NULL || name not found */
	    radio_cardnum = gl_cardnum;
	    add_radionum(name, gl_cardnum);
	}
	/* FALL TO NEXT */
      case enum_CHECKBOX:
	if (value == NULL) value = "on";
	break;
      case enum_SUBMIT:
	if (value == NULL) value = "submit"; /* label of a button */
	break;
      case enum_RESET:
	if (value == NULL) value = "reset"; /* label of a button */
	break;
      default:
 	break;
    }

    if (value) {
	enc_value = url_encode(value);
	/* if (qc) value--; */
	/* my_free(value) */
    }

    /*****************/
    /*** print tag ***/
    /*****************/
    switch (type) {
      case enum_TEXT:
      case enum_PASSWORD:
	sprintf(print_str,
		"<A TASK=GOSUB DEST='#t' RECEIVE='v%d'>$v%d</A>",
		gl_cardnum, gl_cardnum);
	break;
      case enum_CHECKBOX:
	if (name) {
	    sprintf(print_str,
		    "<A TASK=GOSUB DEST='#cb$t%d' RECEIVE='e%d;t%d'"
		    " VARS=e=%s%%3d%s%%26>$t%d</A>",
		    gl_cardnum, gl_cardnum, gl_cardnum,
		    name, enc_value, gl_cardnum);
	} else {
	    sprintf(print_str,
		    "<A TASK=GOSUB DEST='#cb$t%d' RECEIVE=';t%d'>$t%d</A>",
		    gl_cardnum, gl_cardnum, gl_cardnum);
	}
	break;
      case enum_RADIO:
	if (name) {
	    sprintf(print_str,
		    "<A TASK=GOSUB DEST='#rb$t%d' FRIEND='TRUE'"
		    " RECEIVE='e%d;x%d;t%d'"
		    " VARS=e=%s%%3d%s%%26&x=$x%d&y=%d>$t%d</A>",
		    gl_cardnum, radio_cardnum, radio_cardnum, gl_cardnum,
		    name, enc_value, radio_cardnum, gl_cardnum, gl_cardnum);
	} else {
	    sprintf(print_str,
		    "<A TASK=GOSUB DEST='#rbo' RECEIVE=';;t%d'>$t%d</A>",
		    gl_cardnum, gl_cardnum);
	}
	break;
      case enum_SUBMIT:
	if (gl_form_dest) {
	    if (strcmpi(gl_form_method, "get") == 0) {
		sprintf(print_str,
			"<A TASK=GOSUB METHOD='%s' DEST='%s?",
			gl_form_method, gl_form_dest);
	    } else {
		sprintf(print_str,
			"<A TASK=GOSUB DEST='%s' METHOD='%s' POSTDATA='",
			gl_form_dest, gl_form_method);
	    }
	    add_piece(enum_body, print_str);
	    if (name) {
		append_varlist(enum_body, enum_submit, 0);
		/*gl_body = append_block(gl_body, gl_submit);*/
		sprintf(print_str, "%s=%s'>%s</A>", name, enc_value, value);
	    } else {
		append_varlist(enum_body, enum_submit, 1);
		sprintf(print_str, "'>%s</A>", value);
	    }
	}
	break;
      case enum_RESET:
	sprintf(print_str, "<A TASK='GOSUB' FRIEND='TRUE' DEST='#r%d'>%s</A>",
		gl_formnum, value);
	break;
      default:
	break;
    }
    add_piece_with_sp_char(enum_body, print_str);

    /******************/
    /*** print card ***/
    /******************/
    switch (type) {
      case enum_TEXT:
      case enum_PASSWORD:
	add_text_card();
	break;
      case enum_CHECKBOX:
	add_cb_card();
	break;
      case enum_RADIO:
	add_rb_card();
	break;
      case enum_HIDDEN:
	break;
      case enum_SUBMIT:
	break;
      case enum_RESET:
	add_reset_card(gl_formnum);
	break;
      default:
	break;
    }

    /*************************/
    /*** add init variable ***/
    /*************************/
    strcpy(print_str, "");
    switch (type) {
      case enum_TEXT:
      case enum_PASSWORD:
	if (name) {
	    /* $v1=value */
	    sprintf(print_str, "v%d=%s&", gl_cardnum,
		    enc_value ? enc_value: "");
	}
	break;
      case enum_CHECKBOX:
	sprintf(print_str, "t%d=%s&",
		gl_cardnum, checked ? "x" : "" );

	if (name) {
	    char *p;
	    p = strchr(print_str, '\0');
	    if (checked) {
		/* e1=name=value& & */
		sprintf(p, "e%d=%s%%3d%s%%26&",
			gl_cardnum, name, enc_value);
	    } else {
		/* e1= & */
		sprintf(p, "e%d=&", gl_cardnum);
	    }
	}
	break;
      case enum_RADIO:
	sprintf(print_str, "t%d=%s&",
		gl_cardnum, checked ? "o" : "");
	if (checked) {
	    char *p;
	    p = strchr(print_str, '\0');
	    sprintf(p, "x%d=%d&" "e%d=&",
		    radio_cardnum, gl_cardnum,
		    radio_cardnum);
	    if (name) {
		p = strchr(print_str, '\0');
		p--;
		sprintf(p, "%s%%3d%s%%26&", name, enc_value);
	    }
	}
	break;
      default:
	break;
    }
    if (strcmp(print_str, "") != 0) {
	add_piece(enum_init, print_str);
	add_piece(enum_reset, print_str);
    }

    /**************************/
    /*** add reset variable ***/
    /**************************/
    strcpy(print_str, "");
    switch (type) {
      case enum_TEXT:
      case enum_PASSWORD:
	break;
      case enum_CHECKBOX:
	break;
      case enum_RADIO:
	break;
      default:
	break;
    }
    if (strcmp(print_str, "") != 0) {
	add_piece(enum_reset, print_str);
    }

    /***************************/
    /*** add submit variable ***/
    /***************************/
    strcpy(print_str, "");
    if (name) {
	switch (type) {
	  case enum_TEXT:
	  case enum_PASSWORD:
	    /* name=$v1 */
	    sprintf(print_str, "%s=$v%d&", name, gl_cardnum);
	    break;
	  case enum_CHECKBOX:
	    /* $e1 */
	    /* I THINK there's no need for ':noesc'... */
	    /*sprintf(print_str, "$e%d", gl_cardnum);*/
	    sprintf(print_str, "$(e%d:noesc)", gl_cardnum);
	    break;
	  case enum_RADIO:
	    /* $e1 */
	    /* I THINK there's no need for ':noesc'... */
	    /*sprintf(print_str, "$e%d", gl_cardnum);*/
	    if (radio_cardnum == gl_cardnum) {
		sprintf(print_str, "$(e%d:noesc)", radio_cardnum);
	    }
	    break;
	  case enum_HIDDEN:
	    /* name=$v1 */
	    sprintf(print_str, "%s=%s&", name, enc_value);
	    break;
	  default:
	    break;
	}
    }
    if (strcmp(print_str, "") != 0) {
	add_piece_with_sp_char(enum_submit, print_str);
    }

    return 0;
}

int convert_SELECT_(char *stago, char *elemname, char **attr, char *tagc)
{
    alignment();

    add_piece(enum_footer, "</CHOICE>\n");

/*
    fprintf(stderr, "%s\n", gl_select_1st_var);
*/

    if (gl_select_1st_var) {
	gl_already_selected = 0;
	if (gl_select_selected_var == NULL) {
	    gl_select_selected_var = gl_select_1st_var;
	} else {
	    my_free(gl_select_1st_var);
	}
	gl_select_1st_var = NULL;

	add_piece(enum_init, gl_select_selected_var);
	add_piece(enum_reset, gl_select_selected_var);
	my_free(gl_select_selected_var);
	gl_select_selected_var = NULL;

	catdup_varlist(enum_init, enum_select_selected);
	catdup_varlist(enum_reset, enum_select_selected);

	reset_varlist(enum_select_selected);
	
	add_piece(enum_init, "&");
	add_piece(enum_reset, "&");

    } else {
	/* huh? */
    }
    return 0;
}

int convert_SELECT(char *stago, char *elemname, char **attr, char *tagc)
{
    /* char *str; */
    /* char *p; */
    char *name = NULL;
    /* char qc; */ /* quoting character: [\0\'\"] */
    /* int len = 0; */
    char print_str[BUFFER_SIZE];

    alignment();

    strcpy(print_str, "");

    name = remove_quote(attr[(int)enum_NAME]);

    gl_cardnum++;

    /*************************/
    /*** set default value ***/
    /*************************/

    /*****************/
    /*** print tag ***/
    /*****************/
    sprintf(print_str,
	    "<A TASK='GOSUB' DEST='#%d' RECEIVE='v%d;t%d'>$t%d</A>",
	    gl_cardnum, gl_cardnum, gl_cardnum, gl_cardnum);
    add_piece_with_sp_char(enum_body, print_str);

    sprintf(print_str,
	    "<CHOICE NAME='%d'>\n",
	    gl_cardnum);
    add_piece(enum_footer, print_str);

    /*************************/
    /*** add init variable ***/
    /*************************/
    strcpy(print_str, "");
    if (strcmp(print_str, "") != 0) {
	add_piece(enum_init, print_str);
	add_piece(enum_reset, print_str);
    }

    /**************************/
    /*** add reset variable ***/
    /**************************/
    strcpy(print_str, "");
    if (strcmp(print_str, "") != 0) {
	add_piece(enum_reset, print_str);
    }

    /***************************/
    /*** add submit variable ***/
    /***************************/
    if (name) {
	sprintf(print_str, "%s=$(v%d:noesc)&", name, gl_cardnum);
	add_piece_with_sp_char(enum_submit, print_str);
    }

    my_free(name);

    return 0;
}

int convert_OPTION(char *stago, char *elemname, char **attr, char *tagc)
{
    char *value, *enc_value = NULL;
    char *selected;
    char print_str[BUFFER_SIZE];

    alignment();

    value = remove_quote(attr[(int)enum_VALUE]); /* VALUE */
    if (value == NULL) value = "";

    selected = attr[(int)enum_SELECTED]; /* SELECTED */

    if (value) {
	enc_value = url_double_encode(value);
    }

    /*************************/
    /*** set default value ***/
    /*************************/

    /*************************/
    /*** add init variable ***/
    /*************************/

    /* v1= & t1= */
    sprintf(print_str, "v%d=%s&" "t%d=",
	    gl_cardnum, enc_value,
	    gl_cardnum);

    if (gl_select_1st_var == NULL) {
	gl_select_1st_var = my_strdup(print_str);
	set_select_selected();
    }
    if (!gl_already_selected && selected) {
	gl_already_selected = 1;
	gl_select_selected_var = my_strdup(print_str);
	set_select_selected();
    }
/*
    if (strcmp(print_str, "") != 0) {
	add_piece(enum_init, print_str);
	add_piece(enum_reset, print_str);
    }
*/

    /**************************/
    /*** add reset variable ***/
    /**************************/
    strcpy(print_str, "");
    if (!selected) {
	/* t1= */
	/* sprintf(print_str, "t%d=&", gl_cardnum); */
	
	/* e0= & x0= */
	
    }
    if (strcmp(print_str, "") != 0) {
	add_piece(enum_reset, print_str);
    }

    /*****************/
    /*** print tag ***/
    /*****************/
    if (is_current_output(enum_select)) {
	sprintf(print_str,
		"<CE TASK='RETURN' RETVALS='%s;",
		enc_value);
	add_piece(enum_footer, print_str);
	append_varlist(enum_footer, enum_select, 1);
	add_piece(enum_footer, "'>");
    }

    return 0;
}

int convert_BASE(char *stago, char *elemname, char **attr, char *tagc)
{
    char *href, *p1, *p2;
    int len;

    href = remove_quote(attr[(int)enum_HREF]); /* HREF */
    if (href == NULL) return 0;

    p1 = strstr(href, ":/");
    p2 = strchr(href, '/');

    if (p1 == NULL) return 0;
    if (p2 < p1) return 0;
    /* p2 = p1+1 */
    while (*p2 == '/') p2++;

    p2 = strchr(p2, '/');
    if (p2 == NULL) {
	p2 = strchr(href, '\0');
    }

    len = p2-href;

    p1 = my_malloc((len+1)*sizeof(char));
    strncpy(p1, href, len);
    p1[len] = '\0';
    gl_base_abs = p1;

    if (*p2 == '\0') {
	len++;
	p1 = my_malloc((len+1)*sizeof(char));
	strncpy(p1, href, len-1);
	p1[len-1] = '/';
	p1[len] = '\0';
    } else {
	p2 = strrchr(p2, '/');
	len = p2-href+1;
	p1 = my_malloc((len+1)*sizeof(char));
	strncpy(p1, href, len);
	p1[len] = '\0';
    }
    gl_base_rel = p1;

/*
    fprintf(stderr, "%s\n", gl_base_abs);
    fprintf(stderr, "%s\n", gl_base_rel);
*/
    return 0;
}

/* return appropriate BASE string (see convert_BASE().)*/
char *base_url(char *href)
{
    if (href == NULL) {
	return NULL;
    } else if (strstr(href, "://")) {
	return NULL;
    } else if (href[0] == '/') {
	if (gl_base_abs) return gl_base_abs;
	else return NULL;
    } else {
	if (gl_base_rel) return gl_base_rel;
	else return NULL;
    }
    return 0;
}

int add_text_card(void)
{
    if (!gl_text_card) {
	char *text_card = "<ENTRY NAME=\"t\" KEY=\"t\">\n"
	    "<ACTION TYPE=\"ACCEPT\" TASK=\"RETURN\" RETVALS=\"$t\">\n"
	    "</ENTRY>\n";
	
	gl_text_card = 1;
	add_piece_with_sp_char(enum_footer, text_card);
    }
    return 0;
}

int add_cb_card(void)
{
    if (!gl_cb_card) {
	char *cb_card = "<NODISPLAY NAME='cb'>\n"
	    "<ACTION TYPE='ACCEPT' TASK='RETURN'"
	    " RETVALS=$e;x>\n"
	    "</NODISPLAY>\n"

	    "<NODISPLAY NAME='cbx'>\n"
	    "<ACTION TYPE='ACCEPT' TASK='RETURN'"
	    " RETVALS=';'>\n"
	    "</NODISPLAY>\n";
	
	gl_cb_card = 1;
	add_piece_with_sp_char(enum_footer, cb_card);
    }
    return 0;
}

int add_rb_card(void)
{
    if (!gl_rb_card) {
	char *rb_card = "<NODISPLAY NAME='rb'>\n"
	    "<ACTION TYPE='ACCEPT' TASK='RETURN'"
	    " VARS='t$x=' RETVALS='$e;$y;o'>\n"
	    "</NODISPLAY>\n"

	    "<NODISPLAY NAME='rbo'>\n"
	    "<ACTION TYPE='ACCEPT' TASK='RETURN'"
	    " RETVALS='$e;$y;o'>\n"
	    "</NODISPLAY>\n";
	
	gl_rb_card = 1;
	add_piece_with_sp_char(enum_footer, rb_card);
    }
    return 0;
}

int add_reset_card(int formnum)
{
    char *format_str = "<NODISPLAY NAME='r%d'>\n"
	"<ACTION TYPE='ACCEPT' TASK='RETURN' VARS='";

    if (gl_reset_card != formnum) {
	char *print_str = NULL;

	gl_reset_card = formnum;
	print_str = my_malloc(sizeof(char)*(strlen(format_str)+16));

	sprintf(print_str, format_str, formnum);
	add_piece(enum_footer, print_str);

	append_varlist(enum_footer, enum_reset, 1);
	/*gl_footer->remove_last_amp = 1;*/

	add_piece(enum_footer, "'>\n</NODISPLAY>\n");

	my_free(print_str);
    }

    return 0;
}
