// html2hdml
// Coprygight (C) 2000-2003 Dino Co.,Ltd.
// http://www.dino.co.jp/
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "html2hdml.h"

struct _radionum_list {
    char *name;
    int cardnum;
    struct _radionum_list *next;
};
typedef struct _radionum_list radionum_list;

radionum_list *gl_radionum_top = NULL;

void clear_radionum(void);
int find_radionum(char *name);
int add_radionum(char *name, int cardnum);

/* internal func */
radionum_list *alloc_radionum_list(void);
int free_radionum_list(radionum_list *top);

void clear_radionum(void)
{
    free_radionum_list(gl_radionum_top);
    gl_radionum_top = NULL;

    return;
}

void init_radionum()
{
    gl_radionum_top = NULL;
}

int find_radionum(char *name)
{
    radionum_list *node;

    if (name == NULL) return -1;

    node = gl_radionum_top;
    while (node) {
	if (strcmpi(name, node->name) == 0) {
	    return node->cardnum;
	}
	node = node->next;
    }
    return -1;
}

int add_radionum(char *name, int cardnum)
{
    radionum_list *node, *next;

    next = gl_radionum_top;
    node = alloc_radionum_list();
    node->next = next;
    node->name = my_strdup(name);
    node->cardnum = cardnum;
    gl_radionum_top = node;

    return 0;
}

radionum_list *alloc_radionum_list(void)
{
    radionum_list *node;
    node = my_malloc(sizeof(radionum_list));
    return node;
}

int free_radionum_list(radionum_list *top)
{
    radionum_list *node, *next;
    node = gl_radionum_top;
    while (node) {
	my_free(node->name);
	next = node->next;
	my_free(node);
	node = next;
    }
    return 0;
}
