// html2hdml
// Coprygight (C) 2000-2003 Dino Co.,Ltd.
// http://www.dino.co.jp/
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
/*
 *  i-mode emoji (http://www.nttdocomo.co.jp/i/tag/emoji/)
 *    
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define EMOJI_FILENAME "emoji.txt"

char *default_emoji_table[] = {
    "",                           /* (dummy) */
    "",                         /*   1 ; 63647 */
    "",                         /*   2 ; 63648 */
    "J",                         /*   3 ; 63649 */
    "",                         /*   4 ; 63650 */
    "",                         /*   5 ; 63651 */
    "䕗",                       /*   6 ; 63652 */
    "",                         /*   7 ; 63653 */
    "J",                       /*   8 ; 63654 */
    "r",                     /*   9 ; 63655 */
    "",                     /*  10 ; 63656 */
    "oq",                     /*  11 ; 63657 */
    "I",                       /*  12 ; 63658 */
    "q",                     /*  13 ; 63659 */
    "",                     /*  14 ; 63660 */
    "V",                     /*  15 ; 63661 */
    "嶍",                       /*  16 ; 63662 */
    "ˎ",                     /*  17 ; 63663 */
    "Rr",                     /*  18 ; 63664 */
    "r",                     /*  19 ; 63665 */
    "",                       /*  20 ; 63666 */
    "X|[c",                   /*  21 ; 63667 */
    "싅",                       /*  22 ; 63668 */
    "St",                     /*  23 ; 63669 */
    "ejX",                     /*  24 ; 63670 */
    "TbJ[",                   /*  25 ; 63671 */
    "XL[",                     /*  26 ; 63672 */
    "oXPbg{[",           /*  27 ; 63673 */
    "[^[X|[c",           /*  28 ; 63674 */
    "|Pbgx",               /*  29 ; 63675 */
    "d",                       /*  30 ; 63676 */
    "nS",                     /*  31 ; 63677 */
    "V",                     /*  32 ; 63678 */
    "ԁiZ_j",               /*  33 ; 63679 */
    "ԁiquj",                 /*  34 ; 63680 */
    "oX",                       /*  35 ; 63681 */
    "D",                         /*  36 ; 63682 */
    "s@",                     /*  37 ; 63683 */
    "",                         /*  38 ; 63684 */
    "r",                       /*  39 ; 63685 */
    "X֋",                     /*  40 ; 63686 */
    "a@",                       /*  41 ; 63687 */
    "s",                       /*  42 ; 63688 */
    "`sl",                     /*  43 ; 63689 */
    "ze",                     /*  44 ; 63690 */
    "Rrj",                   /*  45 ; 63691 */
    "K\\X^h",          /*  46 ; 63692 */
    "ԏ",                     /*  47 ; 63693 */
    "M",                       /*  48 ; 63694 */
    "gC",                     /*  49 ; 63695 */
    "Xg",                 /*  50 ; 63696 */
    "iX",                     /*  51 ; 63697 */
    "o[",                       /*  52 ; 63698 */
    "r[",                     /*  53 ; 63699 */
    "t@[Xgt[h",           /*  54 ; 63700 */
    "ueBbN",                 /*  55 ; 63701 */
    "e@",                     /*  56 ; 63702 */
    "JIP",                   /*  57 ; 63703 */
    "f",                       /*  58 ; 63704 */
    "E΂ߏ",                   /*  59 ; 63705 */
    "Vn",                     /*  60 ; 63706 */
    "y",                       /*  61 ; 63707 */
    "A[g",                     /*  62 ; 63708 */
    "",                       /*  63 ; 63709 */
    "Cxg",                   /*  64 ; 63710 */
    "`Pbg",                   /*  65 ; 63711 */
    "i",                       /*  66 ; 63712 */
    "։",                       /*  67 ; 63713 */
    "J",                     /*  68 ; 63714 */
    "Jo",                     /*  69 ; 63715 */
    "{",                         /*  70 ; 63716 */
    "{",                     /*  71 ; 63717 */
    "v[g",                 /*  72 ; 63718 */
    "o[Xf[",                 /*  73 ; 63719 */
    "db",                       /*  74 ; 63720 */
    "gѓdb",                   /*  75 ; 63721 */
    "",                       /*  76 ; 63722 */
    "su",                       /*  77 ; 63723 */
    "Q[",                     /*  78 ; 63724 */
    "bc",                       /*  79 ; 63725 */
    "n[g",                     /*  80 ; 63726 */
    "Xy[h",                   /*  81 ; 63727 */
    "_C",                     /*  82 ; 63728 */
    "Nu",                     /*  83 ; 63729 */
    "",                         /*  84 ; 63730 */
    "",                         /*  85 ; 63731 */
    "iO[j",                 /*  86 ; 63732 */
    "i`Lj",               /*  87 ; 63733 */
    "ip[j",                 /*  88 ; 63734 */
    "E΂߉",                   /*  89 ; 63735 */
    "΂ߏ",                   /*  90 ; 63736 */
    "",                         /*  91 ; 63737 */
    "",                       /*  92 ; 63738 */
    "ዾ",                       /*  93 ; 63739 */
    "Ԉ֎q",                     /*  94 ; 63740 */

/* f940 */
    "V",                       /*  95 ; 63808 */
    "⌇",                 /*  96 ; 63809 */
    "",                       /*  97 ; 63810 */
    "O",                     /*  98 ; 63811 */
    "",                       /*  99 ; 63812 */
    "",                         /* 100 ; 63813 */
    "L",                         /* 101 ; 63814 */
    "][g",                   /* 102 ; 63815 */
    "NX}X",                 /* 103 ; 63816 */
    "΂߉",                   /* 104 ; 63817 */

/* f972 */
    "phone to",                   /* 105 ; 63858 */
    "mail to",                    /* 106 ; 63859 */
    "fax to",                     /* 107 ; 63860 */
    "i",                          /* 108 ; 63861 */
    "(i)",                        /* 109 ; 63862 */
    "[",                     /* 110 ; 63863 */
    "hR",                 /* 111 ; 63864 */
    "hR|Cg",             /* 112 ; 63865 */
    "L",                       /* 113 ; 63866 */
    "",                       /* 114 ; 63867 */
    "ID",                         /* 115 ; 63868 */
    "pX[h",                 /* 116 ; 63869 */
    "L",                     /* 117 ; 63870 */

/* f980 */
    "NA",                     /* 118 ; 63872 */
    "T[`iׂj",           /* 119 ; 63873 */
    "mdv",                     /* 120 ; 63874 */
    "ʒu",                   /* 121 ; 63875 */
    "t[_C",             /* 122 ; 63876 */
    "V[v_C",           /* 123 ; 63877 */
    "op",                     /* 124 ; 63878 */
    "(1)",                        /* 125 ; 63879 */
    "(2)",                        /* 126 ; 63880 */
    "(3)",                        /* 127 ; 63881 */
    "(4)",                        /* 128 ; 63882 */
    "(5)",                        /* 129 ; 63883 */
    "(6)",                        /* 130 ; 63884 */
    "(7)",                        /* 131 ; 63885 */
    "(8)",                        /* 132 ; 63886 */
    "(9)",                        /* 133 ; 63887 */
    "(0)",                        /* 134 ; 63888 */

    "",                       /* 135 ; 63920 */

    "n[g",                   /* 136 ; 63889 */
    "hn[g",               /* 137 ; 63890 */
    "",                       /* 138 ; 63891 */
    "n[gin[gj",   /* 139 ; 63892 */
    "[ij",         /* 140 ; 63893 */
    "i{j",           /* 141 ; 63894 */
    "`i_j",       /* 142 ; 63895 */
    "₾`i߂j",     /* 143 ; 63896 */
    "ӂӂ",                   /* 144 ; 63897 */
    "Obhij",       /* 145 ; 63898 */
    "",                   /* 146 ; 63899 */
    "Cij",           /* 147 ; 63900 */
    "킢",                   /* 148 ; 63901 */
    "LX}[N",                 /* 149 ; 63902 */
    "҂҂iVj",         /* 150 ; 63903 */
    "Ђ߂",                   /* 151 ; 63904 */
    "ނi{j",             /* 152 ; 63905 */
    "p`",                     /* 153 ; 63906 */
    "e",                       /* 154 ; 63907 */
    "[h",                     /* 155 ; 63908 */
    "obhij",       /* 156 ; 63909 */
    "zzz",                        /* 157 ; 63910 */
    "!",                          /* 158 ; 63911 */
    "!?",                         /* 159 ; 63912 */
    "!!",                         /* 160 ; 63913 */
    "ǂiՌj",             /* 161 ; 63914 */
    "iюU銾j",     /* 162 ; 63915 */
    "[ij",             /* 163 ; 63916 */
    "_bVio܁j",   /* 164 ; 63917 */
    "[",                         /* 165 ; 63918 */
    "[",                         /* 166 ; 63919 */
};

char *emoji_table[167];

/* OGt@Cǂݍ: tH[}bǵA

Oȏ̋󔒕EGԍEPȏ̋󔒕Eϊ̕

Gԍ http://www.nttdocomo.co.jp/i/tag/emoji/ QƂ̂ƁB

 */
int set_emoji_table()
{
  int i;
  for (i = 0; i <= 166; i++) {
    emoji_table[i] = default_emoji_table[i];
  }

#ifndef MOD_HTML2HDML
  {
    FILE *fp;
    char *emoji_filename;

    emoji_filename = EMOJI_FILENAME;

    fp = fopen(emoji_filename, "r");
    if (fp) {
      char buf[2048];
      while (fgets(buf, 2048, fp)) {
	char *p;
	p = strchr(buf, '\0');
	while (buf < p) {
	  /* s̉sƂ菜 */
	  p--;
	  if (strchr("\r\n", *p) == NULL) break;
	  *p = '\0';
	}
	p = buf + strspn(buf, " \t\r\n"); /* s̋󔒕skip */

	if ((i = strspn(p, "0123456789")) != 0) {
	  long int j;
	  /* i͐ */
	  j = strtol(p, NULL, 10);
	  if (j > 0 && j <= 166) {
	    p += i;
	    if ((i = strspn(p, " \t\r\n")) != 0) {
	      /* i͋󔒕 */
	      p += i;
	      emoji_table[j] = strdup(p);
	    }
	  }
	}
      }
      fclose(fp);
    }
  }
#endif

  return 0;
}
