
/* hsp.h */

#define RGB(r,g,b)	(((r << 8) & 0xf800) | ((g << 3) & 0x07e0) | (b >> 3))

struct HSPPOS {
	int x, y;
};
struct HSPVAR {
	char *string;
	int num;
	int label;
	int mode;
};

typedef int *CHSP3_TASK;
typedef struct HSPVAR PVal;

#ifndef HSP3_MEMVAL
#define HSP3_MEMVAL
extern PVal mem_var[256];
#endif

#define STACKSIZE 512

int loadimg(char *filename, int x, int y);

void __HspEntry(void);
void hsp_task(void);
void InitHSP(void);
void PushStr(char *str);
void PushInt(int i);
void PushLabel(int i);
void PushVar(PVal *var, int i);
void PushVAP(PVal *var, int i);
void PushExtvar(int num, int i);
void PushSysvar(int num, int i);
void PushFuncEnd(void);
void VarSet(PVal *var, int i);
void VarInc(PVal *var, int i);
void CalcAddI(void);
void CalcSubI(void);
void CalcMulI(void);
void CalcEqI(void);
void CalcLtI(void);
void CalcGtI(void);
void CalcLtEqI(void);
void CalcGtEqI(void);
void VarCalc(PVal *var, int i, int j);
int HspIf(void);
void mes(char *s);
void line(int x0, int y0, int x1, int y1);
void Intcmd(int num, int i);
void Extcmd(int num, int i);
void Prgcmd(int num, int i);
void TaskSwitch(int a);

/* end of hsp.h */
