/* 
 * $smu-mark$ 
 * $name: statistics.c$ 
 * $author: Salvatore Sanfilippo <antirez@invece.org>$ 
 * $copyright: Copyright (C) 1999 by Salvatore Sanfilippo$ 
 * $license: This software is under GPL version 2 of license$ 
 * $date: Fri Nov  5 11:55:50 MET 1999$ 
 * $rev: 8$ 
 */
 
/*
 * Revised for Windows: Rob Turpin <rgturpin@epop3.com> 
 *                      8/22/2004          
 */

/*
 *26/11/2008
 *Revised for VC++ 2002 compilable : Mako4th <mako4th@users.sourceforge.jp
 * 
 */

#include <winsock2.h>
#include <windows.h>
#include <stdio.h>
#include <signal.h>
#include <mmsystem.h>
#include "dnet.h"

#include "hping2.h"
#include "globals.h"

extern UINT      wTimerID;



void CALLBACK print_statistics(UINT wTimerID, UINT msg, DWORD dwUser, DWORD dw1, DWORD dw2)
{
	unsigned int lossrate;
	arp_t* a;
    struct arp_entry arp;
    
#if (defined OSTYPE_LINUX) && (!defined FORCE_LIBPCAP)
	close_sockpacket(sockpacket);
#else
	close_pcap();
#endif /* OSTYPE_LINUX && !FORCE_LIBPCAP */

	if (recv_pkt > 0)
		lossrate = 100 - ((recv_pkt*100)/sent_pkt);
	else if (!sent_pkt)
	  lossrate = 0;
	else
	  lossrate = 100;
	fprintf(stderr, "\n--- %s hping statistics ---\n",targetname);
	fprintf(stderr, "%d packets transmitted, %d packets received, "
			"%d%% packet loss\n", sent_pkt, recv_pkt, lossrate);
	if (out_of_sequence_pkt)
		fprintf(stderr, "%d out of sequence packets received\n",
			out_of_sequence_pkt);
	fprintf(stderr, "round-trip min/avg/max = %.1f/%.1f/%.1f ms\n",
		rtt_min, rtt_avg, rtt_max);

	/* manage exit code */

  killPeriod();
  WSACleanup();
  
  a = arp_open();

  
  addr_aton(targetstraddr, &arp.arp_pa);
  arp_delete(a, &arp);
  arp_close(a);
	
  if (opt_tcpexitcode) {
		exit(tcp_exitcode);
	}
	else if (recv_pkt)
	  exit(0);
	else
	  exit(1);
}


void win_print_statistics(int signalID)
{ 
  timeKillEvent( wTimerID );

  if (signalID == SIGINT) {
    setTimer(print_statistics , 2000, TIME_ONESHOT);
  }
  else {
    print_statistics(0, 0, 0, 0, 0);
  }
}