
#include "SyntaxTree.h"
#include "Parser.h"
#include "InputBuffer.h"

// #include <stdio.h>

using namespace Houken;


static SyntaxTree st__PARSE_FAILED(SyntaxTree::V_FAIL);
static SyntaxTree st__NO_SYNTAX_TREE(SyntaxTree::V_INVALID);
static SyntaxTree st__FATAL_PARSER_ERROR(SyntaxTree::V_FATAL_ERROR);
static SyntaxTree st__NOT_PARSED_YET(SyntaxTree::V_INVALID);
static SyntaxTree st__PARSING(SyntaxTree::V_INVALID);

SyntaxTree* const Houken::_PARSE_FAILED = &st__PARSE_FAILED;
SyntaxTree* const Houken::_NO_SYNTAX_TREE = &st__NO_SYNTAX_TREE;
SyntaxTree* const Houken::_FATAL_PARSER_ERROR = &st__FATAL_PARSER_ERROR;
SyntaxTree* const Houken::_NOT_PARSED_YET = &st__NOT_PARSED_YET;
SyntaxTree* const Houken::_PARSING = &st__PARSING;


PtrArray<TArray<SyntaxTree> > SyntaxTree::_memPool(1);


SyntaxTree::SyntaxTree(Valid_e v)
    : str(0,0), parser(NULL), errorCutId(0), _valid(v)
{
    // sys_printf("new null\n");
}

SyntaxTree::SyntaxTree(Parser* p, u32 startPos, u32 endPos, PtrArray<SyntaxTree>* ch)
    : str(startPos, endPos), parser(p), childs(ch), _valid(V_VALID)
{
    // sys_printf("new(%x) st=%d\n",this,startPos);
}

SyntaxTree::SyntaxTree(Parser* p, Substr& ss, PtrArray<SyntaxTree>* ch)
    : str(ss), parser(p), childs(ch), _valid(V_VALID)
{
    // sys_printf("new(%x) st=%d\n",this,ss.startPos);
}

SyntaxTree::SyntaxTree(Parser* p, Substr& ss, int errId)
    : str(ss), parser(p), errorCutId(errId), _valid(V_ERRORCUT)
{
}

SyntaxTree::SyntaxTree(u32 errPos, int errId, Parser* parser)
    : str(errPos, errPos), parser(parser), errorCutId(errId), _valid(V_ERROR)
{
}

SyntaxTree::~SyntaxTree()
{
    // sys_printf("del(%x) st=%d\n",this,str.startPos);
    //deleteAllChild();
    //if (parser != NULL)
    //parser->removeMemo(this);
}

void* SyntaxTree::operator new(size_t size)
{
    assert(size == sizeof(SyntaxTree));
    TArray<SyntaxTree>* p;
    if (_memPool.size() < 1) {
        p = new TArray<SyntaxTree>(100);
        _memPool.add(p);
    } else {
        p = _memPool.get(_memPool.size() - 1);
        if (p->remain() < 1) {
            p = new TArray<SyntaxTree>(p->size() + 100);
            _memPool.add(p);
        }
    }
    return (void*) p->keep();
}

void SyntaxTree::operator delete(void* p)
{
    // delete all by finalize()
}

void SyntaxTree::finalize(void)
{
    PtrArrayIterator<TArray<SyntaxTree> > itr(&_memPool);
    while (itr.hasMore()) {
        delete itr.next();
    }
}

void SyntaxTree::action(Application* ap)
{
    parser->action(this, ap);
}

SyntaxTree* SyntaxTree::erase(int idx)
{
    assert(isValidTree());
    assert(childs != NULL);
    assert(idx < childs->size());
    SyntaxTree* st = childs->extract(idx);
    if (st->isValidTree()) {
        delete st;
    }
    return this;
}

SyntaxTree* SyntaxTree::shrink(void)
{
    assert(isValidTree());
    if (childs != NULL)
        childs->shrink();
    return this;
}

void SyntaxTree::deleteAllChild(void)
{
    assert(isValidTree());
    if (childs == NULL)
        return;

    PtrArrayIterator<SyntaxTree> itr(childs);
    while (itr.hasMore()) {
        SyntaxTree* st = itr.next();
        if (st != NULL)
            delete st;
    }
    delete childs;
    childs = NULL;
}
