
#include "Memoize.h"
#include "SyntaxTree.h"


using namespace Houken;


Memoize::Memoize(void)
    : _memoArr()
{}

Memoize::~Memoize()
{
    while (_memoArr.size() > 0) {
        _memoArr.remove(_memoArr.size() - 1);
    }
}

#define USE_BINSEARCH 0

#if USE_BINSEARCH
int Memoize::_search(u32 pos)
{
    int i = 0;
    int j = _memoArr.size();
    while (i < j) {
        int k = (i + j) / 2;
        u32 kPos = _memoArr.get(k).pos;
        if (kPos == pos)
            return k;
        if (kPos < pos)
            i = k + 1;
        else
            j = k;
    }    
    return j;
}

#else
int Memoize::_search(u32 pos)
{
    int msize = _memoArr.size();
    for (int i = msize - 1; i >= 0; --i) {
        u32 kPos = _memoArr.get(i).pos;
        if (kPos == pos)
            return i;
        if (kPos < pos) {
            return i+1;
        }
    }
    return msize;
}
#endif

SyntaxTree* Memoize::getAt(u32 pos)
{
    int idx = _search(pos);
    if (idx >= _memoArr.size())
        return _NOT_PARSED_YET;
    Memo m = _memoArr.get(idx);
    if (m.pos == pos)
        return m.st;
    return _NOT_PARSED_YET;
}

void Memoize::setAt(u32 pos, SyntaxTree* st)
{
    int idx = _search(pos);
    if (idx >= _memoArr.size()) {
        Memo m = {pos, st};
        _memoArr.add(m);
    } else {
        Memo m = _memoArr.get(idx);
        m.st = st;
        if (m.pos == pos) {
            _memoArr.set(idx, m);
        } else {
            m.pos = pos;
            _memoArr.insertAt(idx, m);
        }
    }
}

void Memoize::remove(SyntaxTree* st)
{
    for (int i = 0; i < _memoArr.size(); ) {
        if (_memoArr.get(i).st == st) {
            _memoArr.remove(i);
            continue;
        }
        ++i;
    }
}
