$KCODE = 's'

begin
	require 'Win32API'
rescue LoadError
	$stderr.puts 'This sample runs only by Windows.'
	exit
end

MessageBox = Win32API.new('user32', 'MessageBox', 'lppl', 'l')
def msgbox(msg)
	MessageBox.call(0,msg.to_s,$0,0)
end


begin
	require 'wintrayicon'
rescue LoadError
	require 'rbconfig'
	$: << "./obj/#{Config::CONFIG["sitearch"]}"
	begin
		require 'wintrayicon'
	rescue LoadError
		msgbox "wintrayicon.so for your platform is not found."
	end
end


class WinApp
	def initialize()
		tray = WinTrayIcon.new
		tray.tip = WinTrayIcon::IDENTIFIER
		tray.load_icon("sample.ico",16,16)
		
		tray.add_menu(WinTrayIcon.to_s) {
			msgbox("#{WinTrayIcon::IDENTIFIER} #{WinTrayIcon::VERSION}")
		}
		tray.add_menu("Check") { |x| x[1] = !x[1] }
		tray.add_menu("Disable")
		tray.add_separater
		tray.add_menu('Quit') { |x| x.close }
		tray.disable(2)

		begin
			while tray.live?
				tray.update
				sleep(0.2)
			end
		rescue Exception
			puts $!.message
			tray.close if tray.live?
		end
	end
end

WinApp.new
