/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  ostimer.c
 * @brief %jp{OS^C}}%en{OS timer}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "kernel.h"
#include "ostimer.h"
#include "wintimer.h"


#define OSTIMER_TIMER_INHNO		1			/**< %jp{݃nhԍ} */


static void OsTimer_IrqHandler(void);		/**< %jp{^C}݃nh} */


/** %jp{OSp^C}[`} */
void OsTimer_Initialize(VP_INT exinf)
{
	T_DINH dfinh;
	
	/* %jp{݃nh`} */
	dfinh.inthdr = (FP)OsTimer_IrqHandler;
	def_inh(OSTIMER_TIMER_INHNO, &dfinh);
	
	/* %jp{^C}Jn} */
	WinTimer_Start(OSTIMER_TIMER_INHNO, 10);
}


/** %jp{^C}݃nh} */
void OsTimer_IrqHandler(void)
{
	isig_tim();
}


/* end of file */
