/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  ostimer.c
 * @brief %jp{OS^C}}%en{OS timer}
 *
 * Copyright (C) 1998-2010 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "kernel.h"
#include "ostimer.h"
#include "regs_sh7262.h"


#define INHNO_OSTIMER			175							/**< %jp{݃nhԍ} */
#define PERIPHERAL_CLOCK		(24000000UL)				/**< %jp{ytFNbN(24MHz)} */


static void OsTimer_IrqHandler(void);						/**< %jp{^C}݃nh} */


/** %jp{OSp^C}[`} */
void OsTimer_Initialize(VP_INT exinf)
{
	T_DINH dfinh;
	
	/* %jp{݃nh`} */
	dfinh.inthdr = (FP)OsTimer_IrqHandler;
	def_inh(INHNO_OSTIMER, &dfinh);
	
	/* %jp{^C}Jn} */
	*REG_STBCR7     &= 0xfffb;								/* %jp{NbN} */
	*REG_CMT_CMSTR  &= 0xfffe;								/* %jp{~} */
	*REG_CMT0_CMCNT  = 0x0000;								/* %jp{JE^NA} */
	*REG_CMT0_CMCOR  = (PERIPHERAL_CLOCK / 128) / 1000;		/* %jp{1msɐݒ} */
	*REG_CMT0_CMCSR  = 0x0042;								/* %jp{128ɐݒ} */
	*REG_CMT_CMSTR  |= 0x0001;								/* %jp{Jn} */
	
	/* %jp{݋} */
	*REG_INTC_IPR10 = ((*REG_INTC_IPR10 & 0xff0f) | 0x0010);
}


/** %jp{^C}݃nh} */
void OsTimer_IrqHandler(void)
{
	/* %jp{tONA}%en{flag clear} */
	*REG_CMT0_CMCSR &= 0xff7f;
	
	isig_tim();
}


/* end of file */
