/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  ostimer.c
 * @brief %jp{OS^C}}%en{OS timer}
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "kernel.h"
#include "ostimer.h"


#define INTNO_TIMER0	0



static void OsTimer_Isr(VP_INT exinf);		/**< %jp{^C}݃T[rX[`} */


/** %jp{OSp^C}[`} */
void OsTimer_Initialize(VP_INT exinf)
{
	T_CISR cisr;
	
	/* %jp{݃T[rX[`} */
	cisr.isratr = TA_HLNG;
	cisr.exinf  = 0;
	cisr.intno  = INTNO_TIMER0;
	cisr.isr    = (FP)OsTimer_Isr;
	acre_isr(&cisr);
	
	/* Jn */
	
	/* ݋ */
	ena_int(INTNO_TIMER0);
}


/** %jp{^C}݃nh} */
void OsTimer_Isr(VP_INT exinf)
{
	/* %jp{^CeBbN} */
	isig_tim();
}



/* end of file */
