/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  sample.c
 * @brief %jp{TvvO}%en{Sample program}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */

#include <stdlib.h>
#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "sci1.h"


#define LEFT(num)	((num) <= 1 ? 5 : (num) - 1)
#define RIGHT(num)	((num) >= 5 ? 1 : (num) + 1)


ID mbxid;
ID mpfid;


/** %jp{bZ[W\} */
typedef struct t_print_msg
{
	T_MSG msg;
	char  text[32];
} T_PRINT_MSG;


/** %jp{nh} */
void Sample_Initialize(VP_INT exinf)
{
	T_CMPF cmpf;
	T_CMBX cmbx;
	
	/* %jp{Œ蒷v[} */
	cmpf.mpfatr = TA_TFIFO;					
	cmpf.blkcnt = 3;						
	cmpf.blksz  = sizeof(T_PRINT_MSG);		
	cmpf.mpf    = NULL;						
	mpfid = acre_mpf(&cmpf);

	/* %jp{[{bNX} */
	cmbx.mbxatr  = TA_TFIFO | TA_TFIFO;		
	cmbx.maxmpri = 1;						
	cmbx.mprihd  = NULL;					
	mbxid = acre_mbx(&cmbx);

	/* %jp{^XNN} */
	act_tsk(TSKID_PRINT);
	act_tsk(TSKID_SAMPLE1);
	act_tsk(TSKID_SAMPLE2);
	act_tsk(TSKID_SAMPLE3);
	act_tsk(TSKID_SAMPLE4);
	act_tsk(TSKID_SAMPLE5);
}


/** %jp{KȎԑ҂} */
void rand_wait(void)
{
	int r;

	wai_sem(SEMID_RAND);
	r = rand();
	sig_sem(SEMID_RAND);

	dly_tsk((r % 1000) + 10);
}


/** %jp{ԕ\} */
void print_state(int num, char *text)
{
	T_PRINT_MSG *msg;
	VP  mem;
	
	/* %jp{擾} */
	get_mpf(mpfid, &mem);
	msg = (T_PRINT_MSG *)mem;

	/* %jp{񐶐} */
	msg->text[0] = '0' + num;
	msg->text[1] = ' ';
	msg->text[2] = ':';
	msg->text[3] = ' ';
	strcpy(&msg->text[4], text);
	strcat(msg->text, "\n");
	
	/* %jp{\^XNɑM} */
	snd_mbx(mbxid, (T_MSG *)msg);
}


/** %jp{Tv^XN} */
void Sample_Task(VP_INT exinf)
{
	int num;
	
	num = (int)exinf;
	
	/* %jp{Nw҂̐H̖} */
	for ( ; ; )
	{
		/* %jp{KȎԍl} */
		print_state(num, "thinking");
		rand_wait();
		
		/* %jp{ẼtH[N܂Ń[v} */
		for ( ; ; )
		{
			/* %jp{珇Ɏ} */
			wai_sem(LEFT(num));
			if ( pol_sem(RIGHT(num)) == E_OK )
			{
				break;	/* %jp{ꂽ} */
			}
			sig_sem(LEFT(num));	/* %jp{ȂΗ} */
			
			/* %jp{KȎԑ҂} */
			print_state(num, "hungry");
			rand_wait();

			/* %jp{E珇Ɏ} */
			wai_sem(RIGHT(num));
			if ( pol_sem(LEFT(num)) == E_OK )
			{
				break;	/* %jp{ꂽ} */
			}
			sig_sem(RIGHT(num));	/* %jp{ȂΗ} */

			/* %jp{KȎԑ҂} */
			print_state(num, "hungry");
			rand_wait();
		}
		
		/* %jp{KȎԁAHׂ} */
		print_state(num, "eating");
		rand_wait();
		
		/* %jp{tH[Nu} */
		sig_sem(LEFT(num));
		sig_sem(RIGHT(num));
	}
}


/** %jp{\^XN} */
void Sample_Print(VP_INT exinf)
{
	T_PRINT_MSG *msg;
	
	for ( ; ; )
	{
		rcv_mbx(mbxid, (T_MSG **)&msg);
		Sci1_PutString(msg->text);
		rel_mpf(mpfid, msg);
	}
}



/* end of file */
