/**
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  sample.c
 * @brief %jp{TvvO}%en{Sample program}
 *
 * Copyright (C) 1998-2011 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */

#include <stdlib.h>
#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "uart.h"


#define LEFT(num)	((num) <= 1 ? 5 : (num) - 1)
#define RIGHT(num)	((num) >= 5 ? 1 : (num) + 1)


/** %jp{nh} */
void Sample_Initialize(VP_INT exinf)
{
	/* %jp{UART} */
	Uart_Initialize();
}


/** %jp{KȎԑ҂} */
void rand_wait(void)
{
	static	long	x = 1;
	int 			r;

	/* [ */
	wai_sem(SEMID_RAND);
	x = x * 214013 + 2531011;
	r = ((x >> 16) & 0xffff);
	sig_sem(SEMID_RAND);

	dly_tsk((r % 100) + 10);
}


/** %jp{ԕ\} */
void print_state(int num, char *text)
{
	wai_sem(SEMID_UART);

	/* %jp{񐶐} */
	Uart_PutChar('0' + num);
	Uart_PutChar(' ');
	Uart_PutChar(':');
	Uart_PutChar(' ');
	Uart_PutString(text);
	Uart_PutChar('\r');
	Uart_PutChar('\n');

	sig_sem(SEMID_UART);
}


/** %jp{Tv^XN} */
void Sample_Task(VP_INT exinf)
{
	int num;

	num = (int)exinf;

	/* %jp{Nw҂̐H̖} */
	for ( ; ; )
	{
		/* %jp{KȎԍl} */
		print_state(num, "thinking");
		rand_wait();

		/* %jp{ẼtH[N܂Ń[v} */
		for ( ; ; )
		{
			/* %jp{珇Ɏ} */
			wai_sem(LEFT(num));
			if ( pol_sem(RIGHT(num)) == E_OK )
			{
				break;	/* %jp{ꂽ} */
			}
			sig_sem(LEFT(num));	/* %jp{ȂΗ} */

			/* %jp{KȎԑ҂} */
			print_state(num, "hungry");
			rand_wait();

			/* %jp{E珇Ɏ} */
			wai_sem(RIGHT(num));
			if ( pol_sem(LEFT(num)) == E_OK )
			{
				break;	/* %jp{ꂽ} */
			}
			sig_sem(RIGHT(num));	/* %jp{ȂΗ} */

			/* %jp{KȎԑ҂} */
			print_state(num, "hungry");
			rand_wait();
		}

		/* %jp{KȎԁAHׂ} */
		print_state(num, "eating");
		rand_wait();

		/* %jp{tH[Nu} */
		sig_sem(LEFT(num));
		sig_sem(RIGHT(num));
	}
}



/* end of file */
