/**
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  ostimer.c
 * @brief %jp{OS^C}}%en{OS timer}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "kernel.h"
#include "ostimer.h"


#define REG_SCSR		((volatile UW *)0xE000E010)		/* SysTick Control and Status Register */
#define REG_SRVR		((volatile UW *)0xE000E014)		/* SysTick Reload Value Register */
#define REG_SCUVR		((volatile UW *)0xE000E018)		/* SysTick Current Value Register */
#define REG_SCAVR		((volatile UW *)0xE000E01c)		/* SysTick Calibration Value Register */


/** %jp{OSp^C}[`} */
void OsTimer_Initialize(VP_INT exinf)
{
	/* %jp{^C}Jn} */
	*REG_SRVR  = 480000;
	*REG_SCUVR = 0;
	*REG_SCSR  = 0x00000007;

	ena_int(15);
}


/** %jp{^C}݃nh} */
void OsTimer_Isr(void)
{
	/* %jp{ݗvNA} */
	vclr_int(15);

	/* %jp{^CeBbN} */
	isig_tim();
}


/* end of file */
