/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  ext_tsk.c
 * @brief %jp{^XN̏I}%en{Exit Task}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/mtxobj.h"


/** %jp{^XN̋I}
 * @return void
 */
ER ter_tsk(ID tskid)
{
	_KERNEL_T_TSKHDL		tskhdl;
	_KERNEL_T_TCB_PTR		tcb;
	_KERNEL_T_TCB_RO_PTR	tcb_ro;
	_KERNEL_TSK_T_ACTCNT	actcnt;
	
	
	/* %jp{ID ̃`FbN} */
#if _KERNEL_SPT_TER_TSK_E_ID
	if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
	{
		return E_ID;	/* %jp{IDs} */
	}
#endif

	_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */

	/* %jp{IuWFNg݃`FbN} */
#if _KERNEL_SPT_TER_TSK_E_NOEXS
	if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
		return E_NOEXS;			/* %jp{IuWFNg} */
	}
#endif


	/* %jp{Rg[ubN擾} */
	tcb    = _KERNEL_TSK_ID2TCB(tskid);
    tskhdl = _KERNEL_TSK_GET_TSKHDL(tskid, tcb);

	/* %jp{s^XNȂG[} */
#if _KERNEL_SPT_TER_TSK_E_ILUSE
	if ( tskhdl == _KERNEL_SYS_GET_RUNTSK() )
	{
		_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
		return E_ILUSE;				/* %jp{T[rXR[sgp} */
	}
#endif
	
	
	/* ԃ`FbN */
#if _KERNEL_SPT_TER_TSK_E_OBJ
	if ( _KERNEL_TSK_GET_TSKSTAT(tcb) == _KERNEL_TTS_DMT )
	{
		_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
		return E_OBJ;				/* %jp{IuWFNgԃG[} */
	}

#endif
	
	
	/* ^XNI */
	_KERNEL_DSP_TER_TSK(tskhdl);
	
	
	/* %jp{L~[ebNXΊJ} */
#if _KERNEL_SPT_MTX
	{
		_KERNEL_T_MTXHDL mtxhdl;
		while ( (mtxhdl = _KERNEL_TSK_GET_MTXHDL(tcb)) != _KERNEL_MTXHDL_NULL )
		{
			_kernel_rmv_mtx(mtxhdl, tskhdl);
		}
	}
#endif
	
	/* %jp{NvlXg̃`FbN} */
	actcnt = _KERNEL_TSK_GET_ACTCNT(tcb);	
	if ( actcnt > 0 )	/* %jp{NvlXgȂĐ} */
	{
		_KERNEL_TSK_T_TPRI itskpri;

		tcb_ro = _KERNEL_TSK_GET_TCB_RO(tskid, tcb);
		_KERNEL_TSK_SET_ACTCNT(tcb, actcnt - 1);
		itskpri = _KERNEL_TSK_GET_ITSKPRI(tcb_ro);
		_KERNEL_TSK_SET_TSKPRI(tcb, itskpri);
		_KERNEL_TSK_SET_TSKBPRI(tcb, itskpri);
		
		/* %jp{fB[L[Đڑ} */
		_KERNEL_DSP_STA_TSK(tskhdl);						
	}
	else				/* %jp{NvlXgȂΏI} */
	{
		_KERNEL_TSK_SET_TSKSTAT(tcb, _KERNEL_TTS_DMT);
	}
	
	/* %jp{^XNfBXpb`̎s}%en{task dispatch} */
	_KERNEL_DSP_TSK();
	
	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */

	return E_OK;
}


/* end of file */
