/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  sta_tsk.c
 * @brief %jp{^XN̋N}%en{Activate Task}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



/** %jp{^XN̋N(NR[hw)}%en{Start Task}
 * @param  tskid   %en{ID number of the task to be activated}%jp{^XNID}
 * @return void
 */
ER sta_tsk(
		ID     tskid,
		VP_INT stacd)
{
	_KERNEL_T_TSKHDL       tskhdl;
	_KERNEL_T_TCB          *tcb;
	const _KERNEL_T_TCB_RO *tcb_ro;
	
	if ( tskid == TSK_SELF )		/* %jp{^XNw莞̕ϊ} */
	{
#if _KERNEL_SPT_STA_TSK_E_ID
		if ( _KERNEL_SYS_SNS_CTX() )
		{
			return E_ID;		/* %jp{sIDԍ} */
		}
#endif
		/* %jp{s^XN擾} */
		tskhdl = _KERNEL_SYS_GET_RUNTSK();
		
		_KERNEL_ENTER_SVC();		/* %jp{enter service-call}%jp{T[rXR[ɓ} */
	}
	else
	{
#if _KERNEL_SPT_STA_TSK_E_ID
		if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
		{
			return E_ID;	/* %jp{sIDԍ} */
		}
#endif
		
		_KERNEL_ENTER_SVC();		/* %jp{enter service-call}%jp{T[rXR[ɓ} */
		
		/* %jp{IuWFNg݃`FbN} */
#if _KERNEL_SPT_STA_TSK_E_NOEXS
		if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
		{
			_KERNEL_LEAVE_SVC();		/* %jp{leave service-call}%jp{T[rXR[o} */
			return E_NOEXS;			/* %jp{IuWFNg} */
		}
#endif
		/* IDԍw莞̕ϊ */
		tskhdl = _KERNEL_TSK_ID2TSKHDL(tskid);
	}
	

	/* %jp{TCB擾} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/* %jp{ԃ`FbN} */
#if _KERNEL_SPT_STA_TSK_E_OBJ
	if ( _KERNEL_TSK_GET_TSKSTAT(tcb) != _KERNEL_TTS_DMT )		/* %jp{IuWFNgԔ} */
	{
		_KERNEL_LEAVE_SVC();
		return E_OBJ;		/* %jp{ԕs} */
	}
#endif

	/* %jp{^XNԏ} */
	tcb_ro = _KERNEL_TSK_GET_TCB_RO(tskid, tcb);
	_KERNEL_TSK_SET_TSKPRI(tcb, _KERNEL_TSK_GET_ITSKPRI(tcb_ro));
	_KERNEL_TSK_SET_TSKBPRI(tcb, _KERNEL_TSK_GET_ITSKPRI(tcb_ro));
	_KERNEL_TSK_SET_TSKSTAT(tcb, _KERNEL_TTS_RDY);
	_KERNEL_TSK_SET_ACTCNT(tcb, 0);
	_KERNEL_TSK_SET_WUPCNT(tcb, 0);
	_KERNEL_TSK_SET_SUSCNT(tcb, 0);
	
	/* %jp{ReLXg} */
	_KERNEL_CRE_CTX(
			_KERNEL_TSK_GET_CTXCB(tcb),					/* %jp{ReLXgubN} */
			_KERNEL_TSK_GET_STKSZ(tcb_ro),				/* %jp{^XÑX^bN̈TCY} */
			_KERNEL_TSK_GET_STK(tcb_ro),				/* %jp{^XÑX^bN̈̐擪Ԓn} */
			(VP)_KERNEL_TSK_GET_ISP(tcb_ro),			/* %jp{X^bN|C^̏l} */
			(FP)_kernel_ent_tsk,						/* %jp{ReLXg̊JnAhX} */
			stacd,										/* %jp{^XN̊g} */
			(VP_INT)_KERNEL_TSK_GET_TASK(tcb_ro)		/* %jp{^XN̋NԒn} */
		);
	
	/* %jp{^XNs\Ԃɐݒ} */
	_KERNEL_DSP_STA_TSK(tskhdl);
	
	/* %jp{^XNfBXpb`̎s}%en{task dispatch} */
	_KERNEL_DSP_TSK();
	
	
	_KERNEL_LEAVE_SVC();		/* %jp{leave service-call}%jp{T[rXR[o} */
	
	
	return E_OK;	/*  */
}


/* end of file */
