/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  rel_wai.c
 * @brief %jp{҂Ԃ̋}%en{Release Task from Waiting}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



#if _KERNEL_SPT_REL_WAI


/** %jp{҂Ԃ̋}%en{Release Task from Waiting}
 * @param  tskid    %jp{҂Ԃ̋Ώۂ̃^XNIDԍ}%en{ID number of the task to be release task from waiting}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(tskids邢͎gpłȂ)}%en{Invalid ID number(tskid is invalid or unusable)}
 * @retval E_NOEXS  %jp{IuWFNg(Ώۃ^XNo^)}%en{Non-existant object(specified task is not registered)}
 * @retval E_OBJ    %jp{IuWFNgԃG[(Ώۃ^XN҂ԂłȂ)}%en{Object state error(specified task is neither in WAITING state)}
 */
ER rel_wai(
		ID tskid)
{
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TCB    *tcb;

	if ( tskid == TSK_SELF )		/* %jp{^XNw莞̕ϊ} */
	{
#if _KERNEL_SPT_REL_WAI_E_ID
		if ( _KERNEL_SYS_SNS_CTX() )
		{
			return E_ID;			/* %jp{sIDԍ}%en{Invalid ID number} */
		}
#endif	
		/* %jp{s^XN擾} */
		tskhdl = _KERNEL_SYS_GET_RUNTSK();

		_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */
	}
	else
	{
#if _KERNEL_SPT_REL_WAI_E_ID
		if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
		{
			return E_ID;			/* %jp{sIDԍ}%en{Invalid ID number} */
		}
#endif
		
		_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en%jp{enter service-call} */
		
		/* %jp{IuWFNg݃`FbN} */
#if _KERNEL_SPT_REL_WAI_E_NOEXS
		if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
		{
			_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{%jp{leave service-call} */
			return E_NOEXS;			/* %jp{IuWFNg}%en{Non-existant object} */
		}
#endif
		/* %jp{IDԍw莞̕ϊ} */
		tskhdl = _KERNEL_TSK_ID2TSKHDL(tskid);
	}
	
	/* %jp{TCB擾}%en{get TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	
	/* %jp{^XNԎ擾`FbN} */
#if _KERNEL_SPT_REL_WAI_E_OBJ
	{
		_KERNEL_TSK_T_TSKSTAT tskstat;

		tskstat = _KERNEL_TSK_GET_TSKSTAT(tcb);
		if ( !(tskstat & _KERNEL_TTS_WAI) )
		{
			_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
			return E_OBJ;			/* %jp{IuWFNgԃG[}%en{Object state error} */
		}
	}
#endif
	
	/* %jp{҂} */
	_KERNEL_TRM_QUE(tskhdl);
	_KERNEL_TSK_SET_ERCD(tcb, E_RLWAI);		/* %jp{G[R[hݒ} */
	_KERNEL_DSP_WUP_TSK(tskhdl);			/* %jp{^XN̑҂} */
		
	/* %jp{^XNfBXpb`̎s}%en{Task dispatch} */
	_KERNEL_DSP_TSK();
	
	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
	
	return E_OK;
}


#else	/* _KERNEL_SPT_REL_WAI */


#if _KERNEL_SPT_REL_WAI_E_NOSPT

/** %jp{҂Ԃ̋}%en{Release Task from Waiting}
 * @param  tskid    %jp{҂Ԃ̋Ώۂ̃^XNIDԍ}%en{ID number of the task to be release task from waiting}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER rel_wai(
		ID tskid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_REL_WAI */



/* end of file */
