/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  kchg_pri.c
 * @brief %jp{^XNDx̕ύX}
 *
 * Copyright (C) 1998-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"


/** %jp{^XNDx̕ύX} */
void _kernel_chg_pri(_KERNEL_T_TSKHDL tskhdl, PRI tskpri)
{
	_KERNEL_T_TCB_PTR  tcb;
	
	/* %jp{^XNnh擾} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	
	/* %jp{V^XNDxݒ} */
	_KERNEL_TSK_SET_TSKPRI(tcb, tskpri);
	
	
	/* %jp{fB[L[q} */
	if ( _KERNEL_TSK_SNS_RDY(tcb) )
	{
		_KERNEL_SYS_RMV_RDQ(tskhdl);
		_KERNEL_SYS_ADD_RDQ(tskhdl);
	}
}


/* end of file */
