/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  iact_tsk.c
 * @brief %en{Activate Task}%jp{^XN̋N}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



#if _KERNEL_SPT_IACT_TSK

#if _KERNEL_SPT_DPC

static void _kernel_dpc_act_tsk(ID tskid, VP_INT param);


/** %jp{^XN̋N}%en{Activate Task}
 * @param  tskid   %jp{^XNID}%en{ID number of the task to be activated}
 * @return void
 */
ER iact_tsk(
		ID tskid)
{
	/* %jp{ID ̃`FbN} */
#if _KERNEL_SPT_IACT_TSK_E_ID
	if ( !_KERNEL_TSK_CHECK_TSKID(flgid) )
	{
		return E_ID;		/* %jp{IDs} */
	}
#endif

#if _KERNEL_SPT_IACT_TSK_E_CTX
	if ( !_KERNEL_SYS_SNS_CTX() )
	{
		return E_CTX;		/* %jp{ReLXgs} */
	}
#endif
	
	/* %jp{xsv} */
	return _KERNEL_SYS_REQ_DPC(_kernel_dpc_act_tsk, tskid, 0);
}


/** %jp{iact_tsk̒xs}%en{service call for delayed executioniact_tsk)} */
void _kernel_dpc_act_tsk(ID tskid, VP_INT param)		
{
	_KERNEL_T_TSKHDL       tskhdl;
	_KERNEL_T_TCB          *tcb;
	const _KERNEL_T_TCB_RO *tcb_ro;
	
	
	/* %jp{IuWFNg݃`FbN} */
#if _KERNEL_SPT_IACT_TSK_E_NOEXS
	if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
	{
		_KERNEL_LEAVE_SVC();		/* %jp{leave service-call}%jp{T[rXR[o} */
		return ;					/* %jp{IuWFNg} */
	}
#endif
	
	/* %jp{TCB擾} */
	tcb = _KERNEL_TSK_ID2TCB(tskid);
	
	/* IDԍw莞̕ϊ */
	tskhdl = _KERNEL_TSK_ID2TSKHDL(tskid);
	

	if ( _KERNEL_TSK_GET_TSKSTAT(tcb) != _KERNEL_TTS_DMT )		/* %jp{IuWFNgԔ} */
	{
#if _KERNEL_TCB_ACTCNT
		{
			_KERNEL_TSK_T_ACTCNT actcnt;

			/* %jp{ɎsԂȂNvL[CO} */
			actcnt = _KERNEL_TSK_GET_ACTCNT(tcb);
		
			/* %jp{ɎsԂȂNvL[CO} */
		#ifdef _KERNEL_CFG_IACT_TSK_E_QOVR
			if ( actcnt >= _KERNEL_TMAX_ACTCNT )
			{
				return;		/* %jp{L[COI[o[t[} */
			}
		#endif

			/* %jp{NvL[CO} */
			_KERNEL_TSK_SET_ACTCNT(tcb, actcnt + 1);
		}
#else
		{
			return;		/* %jp{L[COI[o[t[} */
		}
#endif
	}
	else
	{
		/* %jp{^XNԏ} */
		tcb_ro = _KERNEL_TSK_GET_TCB_RO(tskid, tcb);
		_KERNEL_TSK_SET_TSKPRI(tcb, _KERNEL_TSK_GET_ITSKPRI(tcb_ro));
		_KERNEL_TSK_SET_TSKBPRI(tcb, _KERNEL_TSK_GET_ITSKPRI(tcb_ro));
		_KERNEL_TSK_SET_TSKSTAT(tcb, _KERNEL_TTS_RDY);
		_KERNEL_TSK_SET_ACTCNT(tcb, 0);
		_KERNEL_TSK_SET_WUPCNT(tcb, 0);
		_KERNEL_TSK_SET_SUSCNT(tcb, 0);
		
		/* %jp{ReLXg} */
		_KERNEL_CRE_CTX(
				_KERNEL_TSK_GET_CTXCB(tcb),					/* %jp{ReLXgubN} */
				_KERNEL_TSK_GET_STKSZ(tcb_ro),				/* %jp{^XÑX^bN̈TCY} */
				_KERNEL_TSK_GET_STK(tcb_ro),				/* %jp{^XÑX^bN̈̐擪Ԓn} */
				(VP)_KERNEL_TSK_GET_ISP(tcb_ro),			/* %jp{X^bN|C^̏l} */
				(FP)_kernel_ent_tsk,						/* %jp{ReLXg̊JnAhX} */
				(VP_INT)_KERNEL_TSK_GET_EXINF(tcb_ro),		/* %jp{^XN̊g} */
				(VP_INT)_KERNEL_TSK_GET_TASK(tcb_ro)		/* %jp{^XN̋NԒn} */
			);
		
		/* %jp{^XNs\Ԃɐݒ} */
		_KERNEL_DSP_STA_TSK(tskhdl);
	}
		
	return;	/*  */
}

#else	/* _KERNEL_SPT_DPC */

/** %en{Activate Task}%jp{^XN̋N}
 * @param  tskid   %en{ID number of the task to be activated}%jp{^XNID}
 * @return void
 */
ER iact_tsk(
		ID tskid)
{
	return act_tsk(tskid);
}

#endif	/* _KERNEL_SPT_DPC */

#endif	/* _KERNEL_SPT_IACT_TSK */



/* end of file */
